// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    public partial class DcrConfiguration : IUtf8JsonSerializable, IJsonModel<DcrConfiguration>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<DcrConfiguration>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<DcrConfiguration>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DcrConfiguration>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DcrConfiguration)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("dataCollectionEndpoint"u8);
            writer.WriteStringValue(DataCollectionEndpoint);
            writer.WritePropertyName("dataCollectionRuleImmutableId"u8);
            writer.WriteStringValue(DataCollectionRuleImmutableId);
            writer.WritePropertyName("streamName"u8);
            writer.WriteStringValue(StreamName);
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        DcrConfiguration IJsonModel<DcrConfiguration>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DcrConfiguration>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DcrConfiguration)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeDcrConfiguration(document.RootElement, options);
        }

        internal static DcrConfiguration DeserializeDcrConfiguration(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string dataCollectionEndpoint = default;
            string dataCollectionRuleImmutableId = default;
            string streamName = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("dataCollectionEndpoint"u8))
                {
                    dataCollectionEndpoint = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("dataCollectionRuleImmutableId"u8))
                {
                    dataCollectionRuleImmutableId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("streamName"u8))
                {
                    streamName = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new DcrConfiguration(dataCollectionEndpoint, dataCollectionRuleImmutableId, streamName, serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DataCollectionEndpoint), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  dataCollectionEndpoint: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DataCollectionEndpoint))
                {
                    builder.Append("  dataCollectionEndpoint: ");
                    if (DataCollectionEndpoint.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{DataCollectionEndpoint}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{DataCollectionEndpoint}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DataCollectionRuleImmutableId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  dataCollectionRuleImmutableId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DataCollectionRuleImmutableId))
                {
                    builder.Append("  dataCollectionRuleImmutableId: ");
                    if (DataCollectionRuleImmutableId.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{DataCollectionRuleImmutableId}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{DataCollectionRuleImmutableId}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(StreamName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  streamName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(StreamName))
                {
                    builder.Append("  streamName: ");
                    if (StreamName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{StreamName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{StreamName}'");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<DcrConfiguration>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DcrConfiguration>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(DcrConfiguration)} does not support writing '{options.Format}' format.");
            }
        }

        DcrConfiguration IPersistableModel<DcrConfiguration>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DcrConfiguration>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeDcrConfiguration(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(DcrConfiguration)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<DcrConfiguration>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
