// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Describes the state of user's license for a connector kind. </summary>
    public readonly partial struct DataConnectorLicenseState : IEquatable<DataConnectorLicenseState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataConnectorLicenseState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataConnectorLicenseState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ValidValue = "Valid";
        private const string InvalidValue = "Invalid";
        private const string UnknownValue = "Unknown";

        /// <summary> Valid. </summary>
        public static DataConnectorLicenseState Valid { get; } = new DataConnectorLicenseState(ValidValue);
        /// <summary> Invalid. </summary>
        public static DataConnectorLicenseState Invalid { get; } = new DataConnectorLicenseState(InvalidValue);
        /// <summary> Unknown. </summary>
        public static DataConnectorLicenseState Unknown { get; } = new DataConnectorLicenseState(UnknownValue);
        /// <summary> Determines if two <see cref="DataConnectorLicenseState"/> values are the same. </summary>
        public static bool operator ==(DataConnectorLicenseState left, DataConnectorLicenseState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataConnectorLicenseState"/> values are not the same. </summary>
        public static bool operator !=(DataConnectorLicenseState left, DataConnectorLicenseState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataConnectorLicenseState"/>. </summary>
        public static implicit operator DataConnectorLicenseState(string value) => new DataConnectorLicenseState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataConnectorLicenseState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataConnectorLicenseState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
