// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    public partial class DataConnectorConnectContent : IUtf8JsonSerializable, IJsonModel<DataConnectorConnectContent>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<DataConnectorConnectContent>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<DataConnectorConnectContent>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DataConnectorConnectContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DataConnectorConnectContent)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(Kind))
            {
                writer.WritePropertyName("kind"u8);
                writer.WriteStringValue(Kind.Value.ToString());
            }
            if (Optional.IsDefined(ApiKey))
            {
                writer.WritePropertyName("apiKey"u8);
                writer.WriteStringValue(ApiKey);
            }
            if (Optional.IsDefined(DataCollectionEndpoint))
            {
                writer.WritePropertyName("dataCollectionEndpoint"u8);
                writer.WriteStringValue(DataCollectionEndpoint);
            }
            if (Optional.IsDefined(DataCollectionRuleImmutableId))
            {
                writer.WritePropertyName("dataCollectionRuleImmutableId"u8);
                writer.WriteStringValue(DataCollectionRuleImmutableId);
            }
            if (Optional.IsDefined(OutputStream))
            {
                writer.WritePropertyName("outputStream"u8);
                writer.WriteStringValue(OutputStream);
            }
            if (Optional.IsDefined(ClientSecret))
            {
                writer.WritePropertyName("clientSecret"u8);
                writer.WriteStringValue(ClientSecret);
            }
            if (Optional.IsDefined(ClientId))
            {
                writer.WritePropertyName("clientId"u8);
                writer.WriteStringValue(ClientId);
            }
            if (Optional.IsDefined(AuthorizationCode))
            {
                writer.WritePropertyName("authorizationCode"u8);
                writer.WriteStringValue(AuthorizationCode);
            }
            if (Optional.IsDefined(UserName))
            {
                writer.WritePropertyName("userName"u8);
                writer.WriteStringValue(UserName);
            }
            if (Optional.IsDefined(Password))
            {
                writer.WritePropertyName("password"u8);
                writer.WriteStringValue(Password);
            }
            if (Optional.IsCollectionDefined(RequestConfigUserInputValues))
            {
                writer.WritePropertyName("requestConfigUserInputValues"u8);
                writer.WriteStartArray();
                foreach (var item in RequestConfigUserInputValues)
                {
                    if (item == null)
                    {
                        writer.WriteNullValue();
                        continue;
                    }
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item);
#else
                    using (JsonDocument document = JsonDocument.Parse(item))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        DataConnectorConnectContent IJsonModel<DataConnectorConnectContent>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DataConnectorConnectContent>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(DataConnectorConnectContent)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeDataConnectorConnectContent(document.RootElement, options);
        }

        internal static DataConnectorConnectContent DeserializeDataConnectorConnectContent(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ConnectAuthKind? kind = default;
            string apiKey = default;
            string dataCollectionEndpoint = default;
            string dataCollectionRuleImmutableId = default;
            string outputStream = default;
            string clientSecret = default;
            string clientId = default;
            string authorizationCode = default;
            string userName = default;
            string password = default;
            IList<BinaryData> requestConfigUserInputValues = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("kind"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    kind = new ConnectAuthKind(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("apiKey"u8))
                {
                    apiKey = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("dataCollectionEndpoint"u8))
                {
                    dataCollectionEndpoint = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("dataCollectionRuleImmutableId"u8))
                {
                    dataCollectionRuleImmutableId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("outputStream"u8))
                {
                    outputStream = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("clientSecret"u8))
                {
                    clientSecret = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("clientId"u8))
                {
                    clientId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("authorizationCode"u8))
                {
                    authorizationCode = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("userName"u8))
                {
                    userName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("password"u8))
                {
                    password = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("requestConfigUserInputValues"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<BinaryData> array = new List<BinaryData>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        if (item.ValueKind == JsonValueKind.Null)
                        {
                            array.Add(null);
                        }
                        else
                        {
                            array.Add(BinaryData.FromString(item.GetRawText()));
                        }
                    }
                    requestConfigUserInputValues = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new DataConnectorConnectContent(
                kind,
                apiKey,
                dataCollectionEndpoint,
                dataCollectionRuleImmutableId,
                outputStream,
                clientSecret,
                clientId,
                authorizationCode,
                userName,
                password,
                requestConfigUserInputValues ?? new ChangeTrackingList<BinaryData>(),
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<DataConnectorConnectContent>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DataConnectorConnectContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(DataConnectorConnectContent)} does not support writing '{options.Format}' format.");
            }
        }

        DataConnectorConnectContent IPersistableModel<DataConnectorConnectContent>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<DataConnectorConnectContent>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeDataConnectorConnectContent(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(DataConnectorConnectContent)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<DataConnectorConnectContent>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
