// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The UiConfig for 'Customizable' connector definition kind. </summary>
    public partial class CustomizableConnectorUiConfig
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CustomizableConnectorUiConfig"/>. </summary>
        /// <param name="title"> Gets or sets the connector blade title. </param>
        /// <param name="publisher"> Gets or sets the connector publisher name. </param>
        /// <param name="descriptionMarkdown"> Gets or sets the connector description in markdown format. </param>
        /// <param name="graphQueries"> Gets or sets the graph queries to show the current data volume over time. </param>
        /// <param name="dataTypes"> Gets or sets the data types to check for last data received. </param>
        /// <param name="connectivityCriteria"> Gets or sets the way the connector checks whether the connector is connected. </param>
        /// <param name="permissions"> The required Permissions for the connector. </param>
        /// <param name="instructionSteps"> Gets or sets the instruction steps to enable the connector. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="title"/>, <paramref name="publisher"/>, <paramref name="descriptionMarkdown"/>, <paramref name="graphQueries"/>, <paramref name="dataTypes"/>, <paramref name="connectivityCriteria"/>, <paramref name="permissions"/> or <paramref name="instructionSteps"/> is null. </exception>
        public CustomizableConnectorUiConfig(string title, string publisher, string descriptionMarkdown, IEnumerable<ConnectorGraphQuery> graphQueries, IEnumerable<ConnectorDataType> dataTypes, IEnumerable<ConnectorConnectivityCriterion> connectivityCriteria, ConnectorDefinitionsPermissions permissions, IEnumerable<InstructionStep> instructionSteps)
        {
            Argument.AssertNotNull(title, nameof(title));
            Argument.AssertNotNull(publisher, nameof(publisher));
            Argument.AssertNotNull(descriptionMarkdown, nameof(descriptionMarkdown));
            Argument.AssertNotNull(graphQueries, nameof(graphQueries));
            Argument.AssertNotNull(dataTypes, nameof(dataTypes));
            Argument.AssertNotNull(connectivityCriteria, nameof(connectivityCriteria));
            Argument.AssertNotNull(permissions, nameof(permissions));
            Argument.AssertNotNull(instructionSteps, nameof(instructionSteps));

            Title = title;
            Publisher = publisher;
            DescriptionMarkdown = descriptionMarkdown;
            GraphQueries = graphQueries.ToList();
            DataTypes = dataTypes.ToList();
            ConnectivityCriteria = connectivityCriteria.ToList();
            Permissions = permissions;
            InstructionSteps = instructionSteps.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="CustomizableConnectorUiConfig"/>. </summary>
        /// <param name="id"> Gets or sets custom connector id. optional field. </param>
        /// <param name="title"> Gets or sets the connector blade title. </param>
        /// <param name="publisher"> Gets or sets the connector publisher name. </param>
        /// <param name="descriptionMarkdown"> Gets or sets the connector description in markdown format. </param>
        /// <param name="graphQueries"> Gets or sets the graph queries to show the current data volume over time. </param>
        /// <param name="dataTypes"> Gets or sets the data types to check for last data received. </param>
        /// <param name="connectivityCriteria"> Gets or sets the way the connector checks whether the connector is connected. </param>
        /// <param name="availability"> The exposure status of the connector to the customers. </param>
        /// <param name="permissions"> The required Permissions for the connector. </param>
        /// <param name="instructionSteps"> Gets or sets the instruction steps to enable the connector. </param>
        /// <param name="logo">
        /// Gets or sets the connector logo to be used when displaying the connector within Azure Sentinel's connector's gallery.
        /// The logo value should be in SVG format.
        /// </param>
        /// <param name="isConnectivityCriteriasMatchSome"> Gets or sets a value indicating whether to use 'OR'(SOME) or 'AND' between ConnectivityCriteria items. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CustomizableConnectorUiConfig(string id, string title, string publisher, string descriptionMarkdown, IList<ConnectorGraphQuery> graphQueries, IList<ConnectorDataType> dataTypes, IList<ConnectorConnectivityCriterion> connectivityCriteria, ConnectorDefinitionsAvailability availability, ConnectorDefinitionsPermissions permissions, IList<InstructionStep> instructionSteps, string logo, bool? isConnectivityCriteriasMatchSome, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            Title = title;
            Publisher = publisher;
            DescriptionMarkdown = descriptionMarkdown;
            GraphQueries = graphQueries;
            DataTypes = dataTypes;
            ConnectivityCriteria = connectivityCriteria;
            Availability = availability;
            Permissions = permissions;
            InstructionSteps = instructionSteps;
            Logo = logo;
            IsConnectivityCriteriasMatchSome = isConnectivityCriteriasMatchSome;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="CustomizableConnectorUiConfig"/> for deserialization. </summary>
        internal CustomizableConnectorUiConfig()
        {
        }

        /// <summary> Gets or sets custom connector id. optional field. </summary>
        [WirePath("id")]
        public string Id { get; set; }
        /// <summary> Gets or sets the connector blade title. </summary>
        [WirePath("title")]
        public string Title { get; set; }
        /// <summary> Gets or sets the connector publisher name. </summary>
        [WirePath("publisher")]
        public string Publisher { get; set; }
        /// <summary> Gets or sets the connector description in markdown format. </summary>
        [WirePath("descriptionMarkdown")]
        public string DescriptionMarkdown { get; set; }
        /// <summary> Gets or sets the graph queries to show the current data volume over time. </summary>
        [WirePath("graphQueries")]
        public IList<ConnectorGraphQuery> GraphQueries { get; }
        /// <summary> Gets or sets the data types to check for last data received. </summary>
        [WirePath("dataTypes")]
        public IList<ConnectorDataType> DataTypes { get; }
        /// <summary> Gets or sets the way the connector checks whether the connector is connected. </summary>
        [WirePath("connectivityCriteria")]
        public IList<ConnectorConnectivityCriterion> ConnectivityCriteria { get; }
        /// <summary> The exposure status of the connector to the customers. </summary>
        [WirePath("availability")]
        public ConnectorDefinitionsAvailability Availability { get; set; }
        /// <summary> The required Permissions for the connector. </summary>
        [WirePath("permissions")]
        public ConnectorDefinitionsPermissions Permissions { get; set; }
        /// <summary> Gets or sets the instruction steps to enable the connector. </summary>
        [WirePath("instructionSteps")]
        public IList<InstructionStep> InstructionSteps { get; }
        /// <summary>
        /// Gets or sets the connector logo to be used when displaying the connector within Azure Sentinel's connector's gallery.
        /// The logo value should be in SVG format.
        /// </summary>
        [WirePath("logo")]
        public string Logo { get; set; }
        /// <summary> Gets or sets a value indicating whether to use 'OR'(SOME) or 'AND' between ConnectivityCriteria items. </summary>
        [WirePath("isConnectivityCriteriasMatchSome")]
        public bool? IsConnectivityCriteriasMatchSome { get; set; }
    }
}
