// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Connector definition for kind 'Customizable'. </summary>
    public partial class CustomizableConnectorDefinitionData : SecurityInsightsDataConnectorDefinitionData
    {
        /// <summary> Initializes a new instance of <see cref="CustomizableConnectorDefinitionData"/>. </summary>
        public CustomizableConnectorDefinitionData()
        {
            Kind = DataConnectorDefinitionKind.Customizable;
        }

        /// <summary> Initializes a new instance of <see cref="CustomizableConnectorDefinitionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="kind"> The data connector kind. </param>
        /// <param name="etag"> Etag of the azure resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="createdOn"> Gets or sets the connector definition created date in UTC format. </param>
        /// <param name="lastModifiedOn"> Gets or sets the connector definition last modified date in UTC format. </param>
        /// <param name="connectorUiConfig"> The UiConfig for 'Customizable' connector definition kind. </param>
        /// <param name="connectionsConfig"> The UiConfig for 'Customizable' connector definition kind. </param>
        internal CustomizableConnectorDefinitionData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, DataConnectorDefinitionKind kind, ETag? etag, IDictionary<string, BinaryData> serializedAdditionalRawData, DateTimeOffset? createdOn, DateTimeOffset? lastModifiedOn, CustomizableConnectorUiConfig connectorUiConfig, CustomizableConnectionsConfig connectionsConfig) : base(id, name, resourceType, systemData, kind, etag, serializedAdditionalRawData)
        {
            CreatedOn = createdOn;
            LastModifiedOn = lastModifiedOn;
            ConnectorUiConfig = connectorUiConfig;
            ConnectionsConfig = connectionsConfig;
            Kind = kind;
        }

        /// <summary> Gets or sets the connector definition created date in UTC format. </summary>
        [WirePath("properties.createdTimeUtc")]
        public DateTimeOffset? CreatedOn { get; set; }
        /// <summary> Gets or sets the connector definition last modified date in UTC format. </summary>
        [WirePath("properties.lastModifiedUtc")]
        public DateTimeOffset? LastModifiedOn { get; set; }
        /// <summary> The UiConfig for 'Customizable' connector definition kind. </summary>
        [WirePath("properties.connectorUiConfig")]
        public CustomizableConnectorUiConfig ConnectorUiConfig { get; set; }
        /// <summary> The UiConfig for 'Customizable' connector definition kind. </summary>
        [WirePath("properties.connectionsConfig")]
        public CustomizableConnectionsConfig ConnectionsConfig { get; set; }
    }
}
