// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The UiConfig for 'Customizable' connector definition kind. </summary>
    public partial class CustomizableConnectionsConfig
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CustomizableConnectionsConfig"/>. </summary>
        /// <param name="templateSpecName"> Gets or sets the template name. The template includes ARM templates that can be created by the connector, usually it will be the dataConnectors ARM templates. </param>
        /// <param name="templateSpecVersion"> Gets or sets the template version. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="templateSpecName"/> or <paramref name="templateSpecVersion"/> is null. </exception>
        public CustomizableConnectionsConfig(string templateSpecName, string templateSpecVersion)
        {
            Argument.AssertNotNull(templateSpecName, nameof(templateSpecName));
            Argument.AssertNotNull(templateSpecVersion, nameof(templateSpecVersion));

            TemplateSpecName = templateSpecName;
            TemplateSpecVersion = templateSpecVersion;
        }

        /// <summary> Initializes a new instance of <see cref="CustomizableConnectionsConfig"/>. </summary>
        /// <param name="templateSpecName"> Gets or sets the template name. The template includes ARM templates that can be created by the connector, usually it will be the dataConnectors ARM templates. </param>
        /// <param name="templateSpecVersion"> Gets or sets the template version. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CustomizableConnectionsConfig(string templateSpecName, string templateSpecVersion, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            TemplateSpecName = templateSpecName;
            TemplateSpecVersion = templateSpecVersion;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="CustomizableConnectionsConfig"/> for deserialization. </summary>
        internal CustomizableConnectionsConfig()
        {
        }

        /// <summary> Gets or sets the template name. The template includes ARM templates that can be created by the connector, usually it will be the dataConnectors ARM templates. </summary>
        [WirePath("templateSpecName")]
        public string TemplateSpecName { get; set; }
        /// <summary> Gets or sets the template version. </summary>
        [WirePath("templateSpecVersion")]
        public string TemplateSpecVersion { get; set; }
    }
}
