// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    public partial class CustomizableConnectionsConfig : IUtf8JsonSerializable, IJsonModel<CustomizableConnectionsConfig>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<CustomizableConnectionsConfig>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<CustomizableConnectionsConfig>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CustomizableConnectionsConfig>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CustomizableConnectionsConfig)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("templateSpecName"u8);
            writer.WriteStringValue(TemplateSpecName);
            writer.WritePropertyName("templateSpecVersion"u8);
            writer.WriteStringValue(TemplateSpecVersion);
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        CustomizableConnectionsConfig IJsonModel<CustomizableConnectionsConfig>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CustomizableConnectionsConfig>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CustomizableConnectionsConfig)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeCustomizableConnectionsConfig(document.RootElement, options);
        }

        internal static CustomizableConnectionsConfig DeserializeCustomizableConnectionsConfig(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string templateSpecName = default;
            string templateSpecVersion = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("templateSpecName"u8))
                {
                    templateSpecName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("templateSpecVersion"u8))
                {
                    templateSpecVersion = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new CustomizableConnectionsConfig(templateSpecName, templateSpecVersion, serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TemplateSpecName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  templateSpecName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TemplateSpecName))
                {
                    builder.Append("  templateSpecName: ");
                    if (TemplateSpecName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{TemplateSpecName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{TemplateSpecName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TemplateSpecVersion), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  templateSpecVersion: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TemplateSpecVersion))
                {
                    builder.Append("  templateSpecVersion: ");
                    if (TemplateSpecVersion.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{TemplateSpecVersion}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{TemplateSpecVersion}'");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<CustomizableConnectionsConfig>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CustomizableConnectionsConfig>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(CustomizableConnectionsConfig)} does not support writing '{options.Format}' format.");
            }
        }

        CustomizableConnectionsConfig IPersistableModel<CustomizableConnectionsConfig>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CustomizableConnectionsConfig>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeCustomizableConnectionsConfig(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(CustomizableConnectionsConfig)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<CustomizableConnectionsConfig>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
