// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The kind of the entity query that supports put request. </summary>
    internal readonly partial struct CustomEntityQueryKind : IEquatable<CustomEntityQueryKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CustomEntityQueryKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CustomEntityQueryKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActivityValue = "Activity";

        /// <summary> Activity. </summary>
        public static CustomEntityQueryKind Activity { get; } = new CustomEntityQueryKind(ActivityValue);
        /// <summary> Determines if two <see cref="CustomEntityQueryKind"/> values are the same. </summary>
        public static bool operator ==(CustomEntityQueryKind left, CustomEntityQueryKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CustomEntityQueryKind"/> values are not the same. </summary>
        public static bool operator !=(CustomEntityQueryKind left, CustomEntityQueryKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CustomEntityQueryKind"/>. </summary>
        public static implicit operator CustomEntityQueryKind(string value) => new CustomEntityQueryKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CustomEntityQueryKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CustomEntityQueryKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
