// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary>
    /// Required permissions for the connector resource provider that define in ResourceProviders.
    /// For more information about the permissions see &lt;see href="https://docs.microsoft.com/en-us/azure/role-based-access-control/role-definitions#actions-format"&gt;here&lt;/see&gt;.
    /// </summary>
    public partial class ConnectorResourceProviderRequiredPermissions
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ConnectorResourceProviderRequiredPermissions"/>. </summary>
        public ConnectorResourceProviderRequiredPermissions()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ConnectorResourceProviderRequiredPermissions"/>. </summary>
        /// <param name="isReadAction"> Gets or sets a value indicating whether the permission is read action (GET). </param>
        /// <param name="isWriteAction"> Gets or sets a value indicating whether the permission is write action (PUT or PATCH). </param>
        /// <param name="isDeleteAction"> Gets or sets a value indicating whether the permission is delete action (DELETE). </param>
        /// <param name="isCustomAction"> Gets or sets a value indicating whether the permission is custom actions (POST). </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ConnectorResourceProviderRequiredPermissions(bool? isReadAction, bool? isWriteAction, bool? isDeleteAction, bool? isCustomAction, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IsReadAction = isReadAction;
            IsWriteAction = isWriteAction;
            IsDeleteAction = isDeleteAction;
            IsCustomAction = isCustomAction;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets a value indicating whether the permission is read action (GET). </summary>
        [WirePath("read")]
        public bool? IsReadAction { get; set; }
        /// <summary> Gets or sets a value indicating whether the permission is write action (PUT or PATCH). </summary>
        [WirePath("write")]
        public bool? IsWriteAction { get; set; }
        /// <summary> Gets or sets a value indicating whether the permission is delete action (DELETE). </summary>
        [WirePath("delete")]
        public bool? IsDeleteAction { get; set; }
        /// <summary> Gets or sets a value indicating whether the permission is custom actions (POST). </summary>
        [WirePath("action")]
        public bool? IsCustomAction { get; set; }
    }
}
