// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Provider name. </summary>
    public readonly partial struct ConnectorProviderName : IEquatable<ConnectorProviderName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ConnectorProviderName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ConnectorProviderName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MicrosoftOperationalInsightsSolutionsValue = "Microsoft.OperationalInsights/solutions";
        private const string MicrosoftOperationalInsightsWorkspacesValue = "Microsoft.OperationalInsights/workspaces";
        private const string MicrosoftOperationalInsightsWorkspacesDatasourcesValue = "Microsoft.OperationalInsights/workspaces/datasources";
        private const string MicrosoftAadiamDiagnosticSettingsValue = "microsoft.aadiam/diagnosticSettings";
        private const string MicrosoftOperationalInsightsWorkspacesSharedKeysValue = "Microsoft.OperationalInsights/workspaces/sharedKeys";
        private const string MicrosoftAuthorizationPolicyAssignmentsValue = "Microsoft.Authorization/policyAssignments";

        /// <summary> Microsoft.OperationalInsights/solutions. </summary>
        public static ConnectorProviderName MicrosoftOperationalInsightsSolutions { get; } = new ConnectorProviderName(MicrosoftOperationalInsightsSolutionsValue);
        /// <summary> Microsoft.OperationalInsights/workspaces. </summary>
        public static ConnectorProviderName MicrosoftOperationalInsightsWorkspaces { get; } = new ConnectorProviderName(MicrosoftOperationalInsightsWorkspacesValue);
        /// <summary> Microsoft.OperationalInsights/workspaces/datasources. </summary>
        public static ConnectorProviderName MicrosoftOperationalInsightsWorkspacesDatasources { get; } = new ConnectorProviderName(MicrosoftOperationalInsightsWorkspacesDatasourcesValue);
        /// <summary> microsoft.aadiam/diagnosticSettings. </summary>
        public static ConnectorProviderName MicrosoftAadiamDiagnosticSettings { get; } = new ConnectorProviderName(MicrosoftAadiamDiagnosticSettingsValue);
        /// <summary> Microsoft.OperationalInsights/workspaces/sharedKeys. </summary>
        public static ConnectorProviderName MicrosoftOperationalInsightsWorkspacesSharedKeys { get; } = new ConnectorProviderName(MicrosoftOperationalInsightsWorkspacesSharedKeysValue);
        /// <summary> Microsoft.Authorization/policyAssignments. </summary>
        public static ConnectorProviderName MicrosoftAuthorizationPolicyAssignments { get; } = new ConnectorProviderName(MicrosoftAuthorizationPolicyAssignmentsValue);
        /// <summary> Determines if two <see cref="ConnectorProviderName"/> values are the same. </summary>
        public static bool operator ==(ConnectorProviderName left, ConnectorProviderName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ConnectorProviderName"/> values are not the same. </summary>
        public static bool operator !=(ConnectorProviderName left, ConnectorProviderName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ConnectorProviderName"/>. </summary>
        public static implicit operator ConnectorProviderName(string value) => new ConnectorProviderName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ConnectorProviderName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ConnectorProviderName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
