// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The HTTP method, default value GET. </summary>
    public readonly partial struct ConnectorHttpMethodVerb : IEquatable<ConnectorHttpMethodVerb>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ConnectorHttpMethodVerb"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ConnectorHttpMethodVerb(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string GetValue = "GET";
        private const string PostValue = "POST";
        private const string PutValue = "PUT";
        private const string DeleteValue = "DELETE";

        /// <summary> GET. </summary>
        public static ConnectorHttpMethodVerb Get { get; } = new ConnectorHttpMethodVerb(GetValue);
        /// <summary> POST. </summary>
        public static ConnectorHttpMethodVerb Post { get; } = new ConnectorHttpMethodVerb(PostValue);
        /// <summary> PUT. </summary>
        public static ConnectorHttpMethodVerb Put { get; } = new ConnectorHttpMethodVerb(PutValue);
        /// <summary> DELETE. </summary>
        public static ConnectorHttpMethodVerb Delete { get; } = new ConnectorHttpMethodVerb(DeleteValue);
        /// <summary> Determines if two <see cref="ConnectorHttpMethodVerb"/> values are the same. </summary>
        public static bool operator ==(ConnectorHttpMethodVerb left, ConnectorHttpMethodVerb right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ConnectorHttpMethodVerb"/> values are not the same. </summary>
        public static bool operator !=(ConnectorHttpMethodVerb left, ConnectorHttpMethodVerb right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ConnectorHttpMethodVerb"/>. </summary>
        public static implicit operator ConnectorHttpMethodVerb(string value) => new ConnectorHttpMethodVerb(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ConnectorHttpMethodVerb other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ConnectorHttpMethodVerb other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
