// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The graph query to show the volume of data arriving into the workspace over time. </summary>
    public partial class ConnectorGraphQuery
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ConnectorGraphQuery"/>. </summary>
        /// <param name="metricName"> Gets or sets the metric name that the query is checking. For example: 'Total data receive'. </param>
        /// <param name="legend"> Gets or sets the legend for the graph. </param>
        /// <param name="baseQuery">
        /// Gets or sets the base query for the graph.
        /// The base query is wrapped by Sentinel UI infra with a KQL query, that measures the volume over time.
        /// </param>
        /// <exception cref="ArgumentNullException"> <paramref name="metricName"/>, <paramref name="legend"/> or <paramref name="baseQuery"/> is null. </exception>
        public ConnectorGraphQuery(string metricName, string legend, string baseQuery)
        {
            Argument.AssertNotNull(metricName, nameof(metricName));
            Argument.AssertNotNull(legend, nameof(legend));
            Argument.AssertNotNull(baseQuery, nameof(baseQuery));

            MetricName = metricName;
            Legend = legend;
            BaseQuery = baseQuery;
        }

        /// <summary> Initializes a new instance of <see cref="ConnectorGraphQuery"/>. </summary>
        /// <param name="metricName"> Gets or sets the metric name that the query is checking. For example: 'Total data receive'. </param>
        /// <param name="legend"> Gets or sets the legend for the graph. </param>
        /// <param name="baseQuery">
        /// Gets or sets the base query for the graph.
        /// The base query is wrapped by Sentinel UI infra with a KQL query, that measures the volume over time.
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ConnectorGraphQuery(string metricName, string legend, string baseQuery, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            MetricName = metricName;
            Legend = legend;
            BaseQuery = baseQuery;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ConnectorGraphQuery"/> for deserialization. </summary>
        internal ConnectorGraphQuery()
        {
        }

        /// <summary> Gets or sets the metric name that the query is checking. For example: 'Total data receive'. </summary>
        [WirePath("metricName")]
        public string MetricName { get; set; }
        /// <summary> Gets or sets the legend for the graph. </summary>
        [WirePath("legend")]
        public string Legend { get; set; }
        /// <summary>
        /// Gets or sets the base query for the graph.
        /// The base query is wrapped by Sentinel UI infra with a KQL query, that measures the volume over time.
        /// </summary>
        [WirePath("baseQuery")]
        public string BaseQuery { get; set; }
    }
}
