// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The graph query to show the current data status. </summary>
    public partial class ConnectorGraphQueries
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ConnectorGraphQueries"/>. </summary>
        public ConnectorGraphQueries()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ConnectorGraphQueries"/>. </summary>
        /// <param name="metricName"> the metric that the query is checking. </param>
        /// <param name="legend"> The legend for the graph. </param>
        /// <param name="baseQuery"> The base query for the graph. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ConnectorGraphQueries(string metricName, string legend, string baseQuery, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            MetricName = metricName;
            Legend = legend;
            BaseQuery = baseQuery;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> the metric that the query is checking. </summary>
        [WirePath("metricName")]
        public string MetricName { get; set; }
        /// <summary> The legend for the graph. </summary>
        [WirePath("legend")]
        public string Legend { get; set; }
        /// <summary> The base query for the graph. </summary>
        [WirePath("baseQuery")]
        public string BaseQuery { get; set; }
    }
}
