// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary>
    /// The resource provider details include the required permissions for the user to create connections.
    /// The user should have the required permissions(Read\Write, ..) in the specified scope ProviderPermissionsScope against the specified resource provider.
    /// </summary>
    public partial class ConnectorDefinitionsResourceProvider
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ConnectorDefinitionsResourceProvider"/>. </summary>
        /// <param name="provider"> Gets or sets the provider name. </param>
        /// <param name="permissionsDisplayText"> Gets or sets the permissions description text. </param>
        /// <param name="providerDisplayName"> Gets or sets the permissions provider display name. </param>
        /// <param name="scope"> The scope on which the user should have permissions, in order to be able to create connections. </param>
        /// <param name="requiredPermissions">
        /// Required permissions for the connector resource provider that define in ResourceProviders.
        /// For more information about the permissions see &lt;see href="https://docs.microsoft.com/en-us/azure/role-based-access-control/role-definitions#actions-format"&gt;here&lt;/see&gt;.
        /// </param>
        /// <exception cref="ArgumentNullException"> <paramref name="provider"/>, <paramref name="permissionsDisplayText"/>, <paramref name="providerDisplayName"/> or <paramref name="requiredPermissions"/> is null. </exception>
        public ConnectorDefinitionsResourceProvider(string provider, string permissionsDisplayText, string providerDisplayName, ProviderPermissionsScope scope, ConnectorResourceProviderRequiredPermissions requiredPermissions)
        {
            Argument.AssertNotNull(provider, nameof(provider));
            Argument.AssertNotNull(permissionsDisplayText, nameof(permissionsDisplayText));
            Argument.AssertNotNull(providerDisplayName, nameof(providerDisplayName));
            Argument.AssertNotNull(requiredPermissions, nameof(requiredPermissions));

            Provider = provider;
            PermissionsDisplayText = permissionsDisplayText;
            ProviderDisplayName = providerDisplayName;
            Scope = scope;
            RequiredPermissions = requiredPermissions;
        }

        /// <summary> Initializes a new instance of <see cref="ConnectorDefinitionsResourceProvider"/>. </summary>
        /// <param name="provider"> Gets or sets the provider name. </param>
        /// <param name="permissionsDisplayText"> Gets or sets the permissions description text. </param>
        /// <param name="providerDisplayName"> Gets or sets the permissions provider display name. </param>
        /// <param name="scope"> The scope on which the user should have permissions, in order to be able to create connections. </param>
        /// <param name="requiredPermissions">
        /// Required permissions for the connector resource provider that define in ResourceProviders.
        /// For more information about the permissions see &lt;see href="https://docs.microsoft.com/en-us/azure/role-based-access-control/role-definitions#actions-format"&gt;here&lt;/see&gt;.
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ConnectorDefinitionsResourceProvider(string provider, string permissionsDisplayText, string providerDisplayName, ProviderPermissionsScope scope, ConnectorResourceProviderRequiredPermissions requiredPermissions, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Provider = provider;
            PermissionsDisplayText = permissionsDisplayText;
            ProviderDisplayName = providerDisplayName;
            Scope = scope;
            RequiredPermissions = requiredPermissions;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="ConnectorDefinitionsResourceProvider"/> for deserialization. </summary>
        internal ConnectorDefinitionsResourceProvider()
        {
        }

        /// <summary> Gets or sets the provider name. </summary>
        [WirePath("provider")]
        public string Provider { get; set; }
        /// <summary> Gets or sets the permissions description text. </summary>
        [WirePath("permissionsDisplayText")]
        public string PermissionsDisplayText { get; set; }
        /// <summary> Gets or sets the permissions provider display name. </summary>
        [WirePath("providerDisplayName")]
        public string ProviderDisplayName { get; set; }
        /// <summary> The scope on which the user should have permissions, in order to be able to create connections. </summary>
        [WirePath("scope")]
        public ProviderPermissionsScope Scope { get; set; }
        /// <summary>
        /// Required permissions for the connector resource provider that define in ResourceProviders.
        /// For more information about the permissions see &lt;see href="https://docs.microsoft.com/en-us/azure/role-based-access-control/role-definitions#actions-format"&gt;here&lt;/see&gt;.
        /// </summary>
        [WirePath("requiredPermissions")]
        public ConnectorResourceProviderRequiredPermissions RequiredPermissions { get; set; }
    }
}
