// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The required Permissions for the connector. </summary>
    public partial class ConnectorDefinitionsPermissions
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ConnectorDefinitionsPermissions"/>. </summary>
        public ConnectorDefinitionsPermissions()
        {
            Tenant = new ChangeTrackingList<string>();
            Licenses = new ChangeTrackingList<string>();
            ResourceProvider = new ChangeTrackingList<ConnectorDefinitionsResourceProvider>();
            Customs = new ChangeTrackingList<CustomPermissionDetails>();
        }

        /// <summary> Initializes a new instance of <see cref="ConnectorDefinitionsPermissions"/>. </summary>
        /// <param name="tenant"> Gets or sets the required tenant permissions for the connector. </param>
        /// <param name="licenses"> Gets or sets the required licenses for the user to create connections. </param>
        /// <param name="resourceProvider"> Gets or sets the resource provider permissions required for the user to create connections. </param>
        /// <param name="customs"> Gets or sets the customs permissions required for the user to create connections. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ConnectorDefinitionsPermissions(IList<string> tenant, IList<string> licenses, IList<ConnectorDefinitionsResourceProvider> resourceProvider, IList<CustomPermissionDetails> customs, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Tenant = tenant;
            Licenses = licenses;
            ResourceProvider = resourceProvider;
            Customs = customs;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets the required tenant permissions for the connector. </summary>
        [WirePath("tenant")]
        public IList<string> Tenant { get; }
        /// <summary> Gets or sets the required licenses for the user to create connections. </summary>
        [WirePath("licenses")]
        public IList<string> Licenses { get; }
        /// <summary> Gets or sets the resource provider permissions required for the user to create connections. </summary>
        [WirePath("resourceProvider")]
        public IList<ConnectorDefinitionsResourceProvider> ResourceProvider { get; }
        /// <summary> Gets or sets the customs permissions required for the user to create connections. </summary>
        [WirePath("customs")]
        public IList<CustomPermissionDetails> Customs { get; }
    }
}
