// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The exposure status of the connector to the customers. </summary>
    public partial class ConnectorDefinitionsAvailability
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ConnectorDefinitionsAvailability"/>. </summary>
        public ConnectorDefinitionsAvailability()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ConnectorDefinitionsAvailability"/>. </summary>
        /// <param name="status"> The exposure status of the connector to the customers. Available values are 0-4 (0=None, 1=Available, 2=FeatureFlag, 3=Internal). </param>
        /// <param name="isPreview"> Gets or sets a value indicating whether the connector is preview. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ConnectorDefinitionsAvailability(int? status, bool? isPreview, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Status = status;
            IsPreview = isPreview;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The exposure status of the connector to the customers. Available values are 0-4 (0=None, 1=Available, 2=FeatureFlag, 3=Internal). </summary>
        [WirePath("status")]
        public int? Status { get; set; }
        /// <summary> Gets or sets a value indicating whether the connector is preview. </summary>
        [WirePath("isPreview")]
        public bool? IsPreview { get; set; }
    }
}
