// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Connector Availability Status. </summary>
    public partial class ConnectorAvailability
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ConnectorAvailability"/>. </summary>
        public ConnectorAvailability()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ConnectorAvailability"/>. </summary>
        /// <param name="status"> The connector Availability Status. </param>
        /// <param name="isPreview"> Set connector as preview. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ConnectorAvailability(ConnectorAvailabilityStatus? status, bool? isPreview, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Status = status;
            IsPreview = isPreview;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The connector Availability Status. </summary>
        [WirePath("status")]
        public ConnectorAvailabilityStatus? Status { get; set; }
        /// <summary> Set connector as preview. </summary>
        [WirePath("isPreview")]
        public bool? IsPreview { get; set; }
    }
}
