// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The authentication kind used to poll the data. </summary>
    public readonly partial struct ConnectAuthKind : IEquatable<ConnectAuthKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ConnectAuthKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ConnectAuthKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BasicValue = "Basic";
        private const string OAuth2Value = "OAuth2";
        private const string APIKeyValue = "APIKey";

        /// <summary> Basic. </summary>
        public static ConnectAuthKind Basic { get; } = new ConnectAuthKind(BasicValue);
        /// <summary> OAuth2. </summary>
        public static ConnectAuthKind OAuth2 { get; } = new ConnectAuthKind(OAuth2Value);
        /// <summary> APIKey. </summary>
        public static ConnectAuthKind APIKey { get; } = new ConnectAuthKind(APIKeyValue);
        /// <summary> Determines if two <see cref="ConnectAuthKind"/> values are the same. </summary>
        public static bool operator ==(ConnectAuthKind left, ConnectAuthKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ConnectAuthKind"/> values are not the same. </summary>
        public static bool operator !=(ConnectAuthKind left, ConnectAuthKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ConnectAuthKind"/>. </summary>
        public static implicit operator ConnectAuthKind(string value) => new ConnectAuthKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ConnectAuthKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ConnectAuthKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
