// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Config to describe the instructions blade. </summary>
    public partial class CodelessUiConnectorConfigProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CodelessUiConnectorConfigProperties"/>. </summary>
        /// <param name="title"> Connector blade title. </param>
        /// <param name="publisher"> Connector publisher name. </param>
        /// <param name="descriptionMarkdown"> Connector description. </param>
        /// <param name="graphQueriesTableName"> Name of the table the connector will insert the data to. </param>
        /// <param name="graphQueries"> The graph query to show the current data status. </param>
        /// <param name="sampleQueries"> The sample queries for the connector. </param>
        /// <param name="dataTypes"> Data types to check for last data received. </param>
        /// <param name="connectivityCriteria"> Define the way the connector check connectivity. </param>
        /// <param name="availability"> Connector Availability Status. </param>
        /// <param name="permissions"> Permissions required for the connector. </param>
        /// <param name="instructionSteps"> Instruction steps to enable the connector. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="title"/>, <paramref name="publisher"/>, <paramref name="descriptionMarkdown"/>, <paramref name="graphQueriesTableName"/>, <paramref name="graphQueries"/>, <paramref name="sampleQueries"/>, <paramref name="dataTypes"/>, <paramref name="connectivityCriteria"/>, <paramref name="availability"/>, <paramref name="permissions"/> or <paramref name="instructionSteps"/> is null. </exception>
        public CodelessUiConnectorConfigProperties(string title, string publisher, string descriptionMarkdown, string graphQueriesTableName, IEnumerable<ConnectorGraphQueries> graphQueries, IEnumerable<SourceControlSampleQueries> sampleQueries, IEnumerable<LastDataReceivedDataType> dataTypes, IEnumerable<ConnectorConnectivityCriteria> connectivityCriteria, ConnectorAvailability availability, ConnectorPermissions permissions, IEnumerable<InstructionSteps> instructionSteps)
        {
            Argument.AssertNotNull(title, nameof(title));
            Argument.AssertNotNull(publisher, nameof(publisher));
            Argument.AssertNotNull(descriptionMarkdown, nameof(descriptionMarkdown));
            Argument.AssertNotNull(graphQueriesTableName, nameof(graphQueriesTableName));
            Argument.AssertNotNull(graphQueries, nameof(graphQueries));
            Argument.AssertNotNull(sampleQueries, nameof(sampleQueries));
            Argument.AssertNotNull(dataTypes, nameof(dataTypes));
            Argument.AssertNotNull(connectivityCriteria, nameof(connectivityCriteria));
            Argument.AssertNotNull(availability, nameof(availability));
            Argument.AssertNotNull(permissions, nameof(permissions));
            Argument.AssertNotNull(instructionSteps, nameof(instructionSteps));

            Title = title;
            Publisher = publisher;
            DescriptionMarkdown = descriptionMarkdown;
            GraphQueriesTableName = graphQueriesTableName;
            GraphQueries = graphQueries.ToList();
            SampleQueries = sampleQueries.ToList();
            DataTypes = dataTypes.ToList();
            ConnectivityCriteria = connectivityCriteria.ToList();
            Availability = availability;
            Permissions = permissions;
            InstructionSteps = instructionSteps.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="CodelessUiConnectorConfigProperties"/>. </summary>
        /// <param name="title"> Connector blade title. </param>
        /// <param name="publisher"> Connector publisher name. </param>
        /// <param name="descriptionMarkdown"> Connector description. </param>
        /// <param name="customImage"> An optional custom image to be used when displaying the connector within Azure Sentinel's connector's gallery. </param>
        /// <param name="graphQueriesTableName"> Name of the table the connector will insert the data to. </param>
        /// <param name="graphQueries"> The graph query to show the current data status. </param>
        /// <param name="sampleQueries"> The sample queries for the connector. </param>
        /// <param name="dataTypes"> Data types to check for last data received. </param>
        /// <param name="connectivityCriteria"> Define the way the connector check connectivity. </param>
        /// <param name="availability"> Connector Availability Status. </param>
        /// <param name="permissions"> Permissions required for the connector. </param>
        /// <param name="instructionSteps"> Instruction steps to enable the connector. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CodelessUiConnectorConfigProperties(string title, string publisher, string descriptionMarkdown, string customImage, string graphQueriesTableName, IList<ConnectorGraphQueries> graphQueries, IList<SourceControlSampleQueries> sampleQueries, IList<LastDataReceivedDataType> dataTypes, IList<ConnectorConnectivityCriteria> connectivityCriteria, ConnectorAvailability availability, ConnectorPermissions permissions, IList<InstructionSteps> instructionSteps, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Title = title;
            Publisher = publisher;
            DescriptionMarkdown = descriptionMarkdown;
            CustomImage = customImage;
            GraphQueriesTableName = graphQueriesTableName;
            GraphQueries = graphQueries;
            SampleQueries = sampleQueries;
            DataTypes = dataTypes;
            ConnectivityCriteria = connectivityCriteria;
            Availability = availability;
            Permissions = permissions;
            InstructionSteps = instructionSteps;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="CodelessUiConnectorConfigProperties"/> for deserialization. </summary>
        internal CodelessUiConnectorConfigProperties()
        {
        }

        /// <summary> Connector blade title. </summary>
        [WirePath("title")]
        public string Title { get; set; }
        /// <summary> Connector publisher name. </summary>
        [WirePath("publisher")]
        public string Publisher { get; set; }
        /// <summary> Connector description. </summary>
        [WirePath("descriptionMarkdown")]
        public string DescriptionMarkdown { get; set; }
        /// <summary> An optional custom image to be used when displaying the connector within Azure Sentinel's connector's gallery. </summary>
        [WirePath("customImage")]
        public string CustomImage { get; set; }
        /// <summary> Name of the table the connector will insert the data to. </summary>
        [WirePath("graphQueriesTableName")]
        public string GraphQueriesTableName { get; set; }
        /// <summary> The graph query to show the current data status. </summary>
        [WirePath("graphQueries")]
        public IList<ConnectorGraphQueries> GraphQueries { get; }
        /// <summary> The sample queries for the connector. </summary>
        [WirePath("sampleQueries")]
        public IList<SourceControlSampleQueries> SampleQueries { get; }
        /// <summary> Data types to check for last data received. </summary>
        [WirePath("dataTypes")]
        public IList<LastDataReceivedDataType> DataTypes { get; }
        /// <summary> Define the way the connector check connectivity. </summary>
        [WirePath("connectivityCriteria")]
        public IList<ConnectorConnectivityCriteria> ConnectivityCriteria { get; }
        /// <summary> Connector Availability Status. </summary>
        [WirePath("availability")]
        public ConnectorAvailability Availability { get; set; }
        /// <summary> Permissions required for the connector. </summary>
        [WirePath("permissions")]
        public ConnectorPermissions Permissions { get; set; }
        /// <summary> Instruction steps to enable the connector. </summary>
        [WirePath("instructionSteps")]
        public IList<InstructionSteps> InstructionSteps { get; }
    }
}
