// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    public partial class CodelessUiConnectorConfigProperties : IUtf8JsonSerializable, IJsonModel<CodelessUiConnectorConfigProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<CodelessUiConnectorConfigProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<CodelessUiConnectorConfigProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CodelessUiConnectorConfigProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CodelessUiConnectorConfigProperties)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("title"u8);
            writer.WriteStringValue(Title);
            writer.WritePropertyName("publisher"u8);
            writer.WriteStringValue(Publisher);
            writer.WritePropertyName("descriptionMarkdown"u8);
            writer.WriteStringValue(DescriptionMarkdown);
            if (Optional.IsDefined(CustomImage))
            {
                writer.WritePropertyName("customImage"u8);
                writer.WriteStringValue(CustomImage);
            }
            writer.WritePropertyName("graphQueriesTableName"u8);
            writer.WriteStringValue(GraphQueriesTableName);
            writer.WritePropertyName("graphQueries"u8);
            writer.WriteStartArray();
            foreach (var item in GraphQueries)
            {
                writer.WriteObjectValue(item, options);
            }
            writer.WriteEndArray();
            writer.WritePropertyName("sampleQueries"u8);
            writer.WriteStartArray();
            foreach (var item in SampleQueries)
            {
                writer.WriteObjectValue(item, options);
            }
            writer.WriteEndArray();
            writer.WritePropertyName("dataTypes"u8);
            writer.WriteStartArray();
            foreach (var item in DataTypes)
            {
                writer.WriteObjectValue(item, options);
            }
            writer.WriteEndArray();
            writer.WritePropertyName("connectivityCriteria"u8);
            writer.WriteStartArray();
            foreach (var item in ConnectivityCriteria)
            {
                writer.WriteObjectValue(item, options);
            }
            writer.WriteEndArray();
            writer.WritePropertyName("availability"u8);
            writer.WriteObjectValue(Availability, options);
            writer.WritePropertyName("permissions"u8);
            writer.WriteObjectValue(Permissions, options);
            writer.WritePropertyName("instructionSteps"u8);
            writer.WriteStartArray();
            foreach (var item in InstructionSteps)
            {
                writer.WriteObjectValue(item, options);
            }
            writer.WriteEndArray();
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        CodelessUiConnectorConfigProperties IJsonModel<CodelessUiConnectorConfigProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CodelessUiConnectorConfigProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CodelessUiConnectorConfigProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeCodelessUiConnectorConfigProperties(document.RootElement, options);
        }

        internal static CodelessUiConnectorConfigProperties DeserializeCodelessUiConnectorConfigProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string title = default;
            string publisher = default;
            string descriptionMarkdown = default;
            string customImage = default;
            string graphQueriesTableName = default;
            IList<ConnectorGraphQueries> graphQueries = default;
            IList<SourceControlSampleQueries> sampleQueries = default;
            IList<LastDataReceivedDataType> dataTypes = default;
            IList<ConnectorConnectivityCriteria> connectivityCriteria = default;
            ConnectorAvailability availability = default;
            ConnectorPermissions permissions = default;
            IList<InstructionSteps> instructionSteps = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("title"u8))
                {
                    title = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("publisher"u8))
                {
                    publisher = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("descriptionMarkdown"u8))
                {
                    descriptionMarkdown = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("customImage"u8))
                {
                    customImage = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("graphQueriesTableName"u8))
                {
                    graphQueriesTableName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("graphQueries"u8))
                {
                    List<ConnectorGraphQueries> array = new List<ConnectorGraphQueries>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ConnectorGraphQueries.DeserializeConnectorGraphQueries(item, options));
                    }
                    graphQueries = array;
                    continue;
                }
                if (property.NameEquals("sampleQueries"u8))
                {
                    List<SourceControlSampleQueries> array = new List<SourceControlSampleQueries>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(SourceControlSampleQueries.DeserializeSourceControlSampleQueries(item, options));
                    }
                    sampleQueries = array;
                    continue;
                }
                if (property.NameEquals("dataTypes"u8))
                {
                    List<LastDataReceivedDataType> array = new List<LastDataReceivedDataType>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(LastDataReceivedDataType.DeserializeLastDataReceivedDataType(item, options));
                    }
                    dataTypes = array;
                    continue;
                }
                if (property.NameEquals("connectivityCriteria"u8))
                {
                    List<ConnectorConnectivityCriteria> array = new List<ConnectorConnectivityCriteria>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(ConnectorConnectivityCriteria.DeserializeConnectorConnectivityCriteria(item, options));
                    }
                    connectivityCriteria = array;
                    continue;
                }
                if (property.NameEquals("availability"u8))
                {
                    availability = ConnectorAvailability.DeserializeConnectorAvailability(property.Value, options);
                    continue;
                }
                if (property.NameEquals("permissions"u8))
                {
                    permissions = ConnectorPermissions.DeserializeConnectorPermissions(property.Value, options);
                    continue;
                }
                if (property.NameEquals("instructionSteps"u8))
                {
                    List<InstructionSteps> array = new List<InstructionSteps>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(Models.InstructionSteps.DeserializeInstructionSteps(item, options));
                    }
                    instructionSteps = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new CodelessUiConnectorConfigProperties(
                title,
                publisher,
                descriptionMarkdown,
                customImage,
                graphQueriesTableName,
                graphQueries,
                sampleQueries,
                dataTypes,
                connectivityCriteria,
                availability,
                permissions,
                instructionSteps,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Title), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  title: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Title))
                {
                    builder.Append("  title: ");
                    if (Title.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Title}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Title}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Publisher), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  publisher: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Publisher))
                {
                    builder.Append("  publisher: ");
                    if (Publisher.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Publisher}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Publisher}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DescriptionMarkdown), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  descriptionMarkdown: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DescriptionMarkdown))
                {
                    builder.Append("  descriptionMarkdown: ");
                    if (DescriptionMarkdown.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{DescriptionMarkdown}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{DescriptionMarkdown}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CustomImage), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  customImage: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(CustomImage))
                {
                    builder.Append("  customImage: ");
                    if (CustomImage.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{CustomImage}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{CustomImage}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(GraphQueriesTableName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  graphQueriesTableName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(GraphQueriesTableName))
                {
                    builder.Append("  graphQueriesTableName: ");
                    if (GraphQueriesTableName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{GraphQueriesTableName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{GraphQueriesTableName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(GraphQueries), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  graphQueries: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(GraphQueries))
                {
                    if (GraphQueries.Any())
                    {
                        builder.Append("  graphQueries: ");
                        builder.AppendLine("[");
                        foreach (var item in GraphQueries)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  graphQueries: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SampleQueries), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  sampleQueries: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(SampleQueries))
                {
                    if (SampleQueries.Any())
                    {
                        builder.Append("  sampleQueries: ");
                        builder.AppendLine("[");
                        foreach (var item in SampleQueries)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  sampleQueries: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DataTypes), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  dataTypes: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(DataTypes))
                {
                    if (DataTypes.Any())
                    {
                        builder.Append("  dataTypes: ");
                        builder.AppendLine("[");
                        foreach (var item in DataTypes)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  dataTypes: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ConnectivityCriteria), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  connectivityCriteria: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(ConnectivityCriteria))
                {
                    if (ConnectivityCriteria.Any())
                    {
                        builder.Append("  connectivityCriteria: ");
                        builder.AppendLine("[");
                        foreach (var item in ConnectivityCriteria)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  connectivityCriteria: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Availability), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  availability: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Availability))
                {
                    builder.Append("  availability: ");
                    BicepSerializationHelpers.AppendChildObject(builder, Availability, options, 2, false, "  availability: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Permissions), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  permissions: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Permissions))
                {
                    builder.Append("  permissions: ");
                    BicepSerializationHelpers.AppendChildObject(builder, Permissions, options, 2, false, "  permissions: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(InstructionSteps), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  instructionSteps: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(InstructionSteps))
                {
                    if (InstructionSteps.Any())
                    {
                        builder.Append("  instructionSteps: ");
                        builder.AppendLine("[");
                        foreach (var item in InstructionSteps)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  instructionSteps: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<CodelessUiConnectorConfigProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CodelessUiConnectorConfigProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(CodelessUiConnectorConfigProperties)} does not support writing '{options.Format}' format.");
            }
        }

        CodelessUiConnectorConfigProperties IPersistableModel<CodelessUiConnectorConfigProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CodelessUiConnectorConfigProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeCodelessUiConnectorConfigProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(CodelessUiConnectorConfigProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<CodelessUiConnectorConfigProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
