// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Describes the response from the external server. </summary>
    public partial class CodelessConnectorPollingResponseProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CodelessConnectorPollingResponseProperties"/>. </summary>
        /// <param name="eventsJsonPaths"> Describes the path we should extract the data in the response. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="eventsJsonPaths"/> is null. </exception>
        public CodelessConnectorPollingResponseProperties(IEnumerable<string> eventsJsonPaths)
        {
            Argument.AssertNotNull(eventsJsonPaths, nameof(eventsJsonPaths));

            EventsJsonPaths = eventsJsonPaths.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="CodelessConnectorPollingResponseProperties"/>. </summary>
        /// <param name="eventsJsonPaths"> Describes the path we should extract the data in the response. </param>
        /// <param name="successStatusJsonPath"> Describes the path we should extract the status code in the response. </param>
        /// <param name="successStatusValue"> Describes the path we should extract the status value in the response. </param>
        /// <param name="isGzipCompressed"> Describes if the data in the response is Gzip. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CodelessConnectorPollingResponseProperties(IList<string> eventsJsonPaths, string successStatusJsonPath, string successStatusValue, bool? isGzipCompressed, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            EventsJsonPaths = eventsJsonPaths;
            SuccessStatusJsonPath = successStatusJsonPath;
            SuccessStatusValue = successStatusValue;
            IsGzipCompressed = isGzipCompressed;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="CodelessConnectorPollingResponseProperties"/> for deserialization. </summary>
        internal CodelessConnectorPollingResponseProperties()
        {
        }

        /// <summary> Describes the path we should extract the data in the response. </summary>
        [WirePath("eventsJsonPaths")]
        public IList<string> EventsJsonPaths { get; }
        /// <summary> Describes the path we should extract the status code in the response. </summary>
        [WirePath("successStatusJsonPath")]
        public string SuccessStatusJsonPath { get; set; }
        /// <summary> Describes the path we should extract the status value in the response. </summary>
        [WirePath("successStatusValue")]
        public string SuccessStatusValue { get; set; }
        /// <summary> Describes if the data in the response is Gzip. </summary>
        [WirePath("isGzipCompressed")]
        public bool? IsGzipCompressed { get; set; }
    }
}
