// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Describe the request properties needed to successfully pull from the server. </summary>
    public partial class CodelessConnectorPollingRequestProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="CodelessConnectorPollingRequestProperties"/>. </summary>
        /// <param name="apiEndpoint"> Describe the endpoint we should pull the data from. </param>
        /// <param name="queryWindowInMin"> The window interval we will use the pull the data. </param>
        /// <param name="httpMethod"> The http method type we will use in the poll request, GET or POST. </param>
        /// <param name="queryTimeFormat"> The time format will be used the query events in a specific window. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="apiEndpoint"/>, <paramref name="httpMethod"/> or <paramref name="queryTimeFormat"/> is null. </exception>
        public CodelessConnectorPollingRequestProperties(string apiEndpoint, int queryWindowInMin, string httpMethod, string queryTimeFormat)
        {
            Argument.AssertNotNull(apiEndpoint, nameof(apiEndpoint));
            Argument.AssertNotNull(httpMethod, nameof(httpMethod));
            Argument.AssertNotNull(queryTimeFormat, nameof(queryTimeFormat));

            ApiEndpoint = apiEndpoint;
            QueryWindowInMin = queryWindowInMin;
            HttpMethod = httpMethod;
            QueryTimeFormat = queryTimeFormat;
        }

        /// <summary> Initializes a new instance of <see cref="CodelessConnectorPollingRequestProperties"/>. </summary>
        /// <param name="apiEndpoint"> Describe the endpoint we should pull the data from. </param>
        /// <param name="rateLimitQps"> Defines the rate limit QPS. </param>
        /// <param name="queryWindowInMin"> The window interval we will use the pull the data. </param>
        /// <param name="httpMethod"> The http method type we will use in the poll request, GET or POST. </param>
        /// <param name="queryTimeFormat"> The time format will be used the query events in a specific window. </param>
        /// <param name="retryCount"> Describe the amount of time we should try and poll the data in case of failure. </param>
        /// <param name="timeoutInSeconds"> The number of seconds we will consider as a request timeout. </param>
        /// <param name="headers"> Describe the headers sent in the poll request. </param>
        /// <param name="queryParameters"> Describe the query parameters sent in the poll request. </param>
        /// <param name="queryParametersTemplate"> For advanced scenarios for example user name/password embedded in nested JSON payload. </param>
        /// <param name="startTimeAttributeName"> This will be used the query events from a start of the time window. </param>
        /// <param name="endTimeAttributeName"> This will be used the query events from the end of the time window. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal CodelessConnectorPollingRequestProperties(string apiEndpoint, int? rateLimitQps, int queryWindowInMin, string httpMethod, string queryTimeFormat, int? retryCount, int? timeoutInSeconds, BinaryData headers, BinaryData queryParameters, string queryParametersTemplate, string startTimeAttributeName, string endTimeAttributeName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ApiEndpoint = apiEndpoint;
            RateLimitQps = rateLimitQps;
            QueryWindowInMin = queryWindowInMin;
            HttpMethod = httpMethod;
            QueryTimeFormat = queryTimeFormat;
            RetryCount = retryCount;
            TimeoutInSeconds = timeoutInSeconds;
            Headers = headers;
            QueryParameters = queryParameters;
            QueryParametersTemplate = queryParametersTemplate;
            StartTimeAttributeName = startTimeAttributeName;
            EndTimeAttributeName = endTimeAttributeName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="CodelessConnectorPollingRequestProperties"/> for deserialization. </summary>
        internal CodelessConnectorPollingRequestProperties()
        {
        }

        /// <summary> Describe the endpoint we should pull the data from. </summary>
        [WirePath("apiEndpoint")]
        public string ApiEndpoint { get; set; }
        /// <summary> Defines the rate limit QPS. </summary>
        [WirePath("rateLimitQps")]
        public int? RateLimitQps { get; set; }
        /// <summary> The window interval we will use the pull the data. </summary>
        [WirePath("queryWindowInMin")]
        public int QueryWindowInMin { get; set; }
        /// <summary> The http method type we will use in the poll request, GET or POST. </summary>
        [WirePath("httpMethod")]
        public string HttpMethod { get; set; }
        /// <summary> The time format will be used the query events in a specific window. </summary>
        [WirePath("queryTimeFormat")]
        public string QueryTimeFormat { get; set; }
        /// <summary> Describe the amount of time we should try and poll the data in case of failure. </summary>
        [WirePath("retryCount")]
        public int? RetryCount { get; set; }
        /// <summary> The number of seconds we will consider as a request timeout. </summary>
        [WirePath("timeoutInSeconds")]
        public int? TimeoutInSeconds { get; set; }
        /// <summary>
        /// Describe the headers sent in the poll request
        /// <para>
        /// To assign an object to this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        [WirePath("headers")]
        public BinaryData Headers { get; set; }
        /// <summary>
        /// Describe the query parameters sent in the poll request
        /// <para>
        /// To assign an object to this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        [WirePath("queryParameters")]
        public BinaryData QueryParameters { get; set; }
        /// <summary> For advanced scenarios for example user name/password embedded in nested JSON payload. </summary>
        [WirePath("queryParametersTemplate")]
        public string QueryParametersTemplate { get; set; }
        /// <summary> This will be used the query events from a start of the time window. </summary>
        [WirePath("startTimeAttributeName")]
        public string StartTimeAttributeName { get; set; }
        /// <summary> This will be used the query events from the end of the time window. </summary>
        [WirePath("endTimeAttributeName")]
        public string EndTimeAttributeName { get; set; }
    }
}
