// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    public partial class CodelessConnectorPollingAuthProperties : IUtf8JsonSerializable, IJsonModel<CodelessConnectorPollingAuthProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<CodelessConnectorPollingAuthProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<CodelessConnectorPollingAuthProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CodelessConnectorPollingAuthProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CodelessConnectorPollingAuthProperties)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("authType"u8);
            writer.WriteStringValue(AuthType);
            if (Optional.IsDefined(ApiKeyName))
            {
                writer.WritePropertyName("apiKeyName"u8);
                writer.WriteStringValue(ApiKeyName);
            }
            if (Optional.IsDefined(ApiKeyIdentifier))
            {
                writer.WritePropertyName("apiKeyIdentifier"u8);
                writer.WriteStringValue(ApiKeyIdentifier);
            }
            if (Optional.IsDefined(IsApiKeyInPostPayload))
            {
                writer.WritePropertyName("isApiKeyInPostPayload"u8);
                writer.WriteStringValue(IsApiKeyInPostPayload);
            }
            if (Optional.IsDefined(FlowName))
            {
                writer.WritePropertyName("flowName"u8);
                writer.WriteStringValue(FlowName);
            }
            if (Optional.IsDefined(TokenEndpoint))
            {
                writer.WritePropertyName("tokenEndpoint"u8);
                writer.WriteStringValue(TokenEndpoint);
            }
            if (Optional.IsDefined(AuthorizationEndpoint))
            {
                writer.WritePropertyName("authorizationEndpoint"u8);
                writer.WriteStringValue(AuthorizationEndpoint);
            }
            if (Optional.IsDefined(AuthorizationEndpointQueryParameters))
            {
                writer.WritePropertyName("authorizationEndpointQueryParameters"u8);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(AuthorizationEndpointQueryParameters);
#else
                using (JsonDocument document = JsonDocument.Parse(AuthorizationEndpointQueryParameters))
                {
                    JsonSerializer.Serialize(writer, document.RootElement);
                }
#endif
            }
            if (Optional.IsDefined(RedirectionEndpoint))
            {
                writer.WritePropertyName("redirectionEndpoint"u8);
                writer.WriteStringValue(RedirectionEndpoint);
            }
            if (Optional.IsDefined(TokenEndpointHeaders))
            {
                writer.WritePropertyName("tokenEndpointHeaders"u8);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(TokenEndpointHeaders);
#else
                using (JsonDocument document = JsonDocument.Parse(TokenEndpointHeaders))
                {
                    JsonSerializer.Serialize(writer, document.RootElement);
                }
#endif
            }
            if (Optional.IsDefined(TokenEndpointQueryParameters))
            {
                writer.WritePropertyName("tokenEndpointQueryParameters"u8);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(TokenEndpointQueryParameters);
#else
                using (JsonDocument document = JsonDocument.Parse(TokenEndpointQueryParameters))
                {
                    JsonSerializer.Serialize(writer, document.RootElement);
                }
#endif
            }
            if (Optional.IsDefined(IsClientSecretInHeader))
            {
                writer.WritePropertyName("isClientSecretInHeader"u8);
                writer.WriteBooleanValue(IsClientSecretInHeader.Value);
            }
            if (Optional.IsDefined(Scope))
            {
                writer.WritePropertyName("scope"u8);
                writer.WriteStringValue(Scope);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        CodelessConnectorPollingAuthProperties IJsonModel<CodelessConnectorPollingAuthProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CodelessConnectorPollingAuthProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CodelessConnectorPollingAuthProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeCodelessConnectorPollingAuthProperties(document.RootElement, options);
        }

        internal static CodelessConnectorPollingAuthProperties DeserializeCodelessConnectorPollingAuthProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string authType = default;
            string apiKeyName = default;
            string apiKeyIdentifier = default;
            string isApiKeyInPostPayload = default;
            string flowName = default;
            string tokenEndpoint = default;
            string authorizationEndpoint = default;
            BinaryData authorizationEndpointQueryParameters = default;
            string redirectionEndpoint = default;
            BinaryData tokenEndpointHeaders = default;
            BinaryData tokenEndpointQueryParameters = default;
            bool? isClientSecretInHeader = default;
            string scope = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("authType"u8))
                {
                    authType = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("apiKeyName"u8))
                {
                    apiKeyName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("apiKeyIdentifier"u8))
                {
                    apiKeyIdentifier = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("isApiKeyInPostPayload"u8))
                {
                    isApiKeyInPostPayload = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("flowName"u8))
                {
                    flowName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("tokenEndpoint"u8))
                {
                    tokenEndpoint = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("authorizationEndpoint"u8))
                {
                    authorizationEndpoint = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("authorizationEndpointQueryParameters"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    authorizationEndpointQueryParameters = BinaryData.FromString(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("redirectionEndpoint"u8))
                {
                    redirectionEndpoint = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("tokenEndpointHeaders"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    tokenEndpointHeaders = BinaryData.FromString(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("tokenEndpointQueryParameters"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    tokenEndpointQueryParameters = BinaryData.FromString(property.Value.GetRawText());
                    continue;
                }
                if (property.NameEquals("isClientSecretInHeader"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isClientSecretInHeader = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("scope"u8))
                {
                    scope = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new CodelessConnectorPollingAuthProperties(
                authType,
                apiKeyName,
                apiKeyIdentifier,
                isApiKeyInPostPayload,
                flowName,
                tokenEndpoint,
                authorizationEndpoint,
                authorizationEndpointQueryParameters,
                redirectionEndpoint,
                tokenEndpointHeaders,
                tokenEndpointQueryParameters,
                isClientSecretInHeader,
                scope,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AuthType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  authType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AuthType))
                {
                    builder.Append("  authType: ");
                    if (AuthType.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{AuthType}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{AuthType}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ApiKeyName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  apiKeyName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ApiKeyName))
                {
                    builder.Append("  apiKeyName: ");
                    if (ApiKeyName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ApiKeyName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ApiKeyName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ApiKeyIdentifier), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  apiKeyIdentifier: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ApiKeyIdentifier))
                {
                    builder.Append("  apiKeyIdentifier: ");
                    if (ApiKeyIdentifier.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ApiKeyIdentifier}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ApiKeyIdentifier}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsApiKeyInPostPayload), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  isApiKeyInPostPayload: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsApiKeyInPostPayload))
                {
                    builder.Append("  isApiKeyInPostPayload: ");
                    if (IsApiKeyInPostPayload.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{IsApiKeyInPostPayload}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{IsApiKeyInPostPayload}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(FlowName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  flowName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(FlowName))
                {
                    builder.Append("  flowName: ");
                    if (FlowName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{FlowName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{FlowName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TokenEndpoint), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  tokenEndpoint: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TokenEndpoint))
                {
                    builder.Append("  tokenEndpoint: ");
                    if (TokenEndpoint.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{TokenEndpoint}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{TokenEndpoint}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AuthorizationEndpoint), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  authorizationEndpoint: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AuthorizationEndpoint))
                {
                    builder.Append("  authorizationEndpoint: ");
                    if (AuthorizationEndpoint.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{AuthorizationEndpoint}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{AuthorizationEndpoint}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AuthorizationEndpointQueryParameters), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  authorizationEndpointQueryParameters: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AuthorizationEndpointQueryParameters))
                {
                    builder.Append("  authorizationEndpointQueryParameters: ");
                    builder.AppendLine($"'{AuthorizationEndpointQueryParameters.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RedirectionEndpoint), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  redirectionEndpoint: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(RedirectionEndpoint))
                {
                    builder.Append("  redirectionEndpoint: ");
                    if (RedirectionEndpoint.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{RedirectionEndpoint}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{RedirectionEndpoint}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TokenEndpointHeaders), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  tokenEndpointHeaders: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TokenEndpointHeaders))
                {
                    builder.Append("  tokenEndpointHeaders: ");
                    builder.AppendLine($"'{TokenEndpointHeaders.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(TokenEndpointQueryParameters), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  tokenEndpointQueryParameters: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(TokenEndpointQueryParameters))
                {
                    builder.Append("  tokenEndpointQueryParameters: ");
                    builder.AppendLine($"'{TokenEndpointQueryParameters.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsClientSecretInHeader), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  isClientSecretInHeader: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsClientSecretInHeader))
                {
                    builder.Append("  isClientSecretInHeader: ");
                    var boolValue = IsClientSecretInHeader.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Scope), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  scope: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Scope))
                {
                    builder.Append("  scope: ");
                    if (Scope.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Scope}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Scope}'");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<CodelessConnectorPollingAuthProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CodelessConnectorPollingAuthProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(CodelessConnectorPollingAuthProperties)} does not support writing '{options.Format}' format.");
            }
        }

        CodelessConnectorPollingAuthProperties IPersistableModel<CodelessConnectorPollingAuthProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CodelessConnectorPollingAuthProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeCodelessConnectorPollingAuthProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(CodelessConnectorPollingAuthProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<CodelessConnectorPollingAuthProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
