// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Type of paging. </summary>
    internal readonly partial struct CcpAuthType : IEquatable<CcpAuthType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CcpAuthType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CcpAuthType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string BasicValue = "Basic";
        private const string APIKeyValue = "APIKey";
        private const string OAuth2Value = "OAuth2";
        private const string AWSValue = "AWS";
        private const string GCPValue = "GCP";
        private const string SessionValue = "Session";
        private const string JwtTokenValue = "JwtToken";
        private const string GitHubValue = "GitHub";
        private const string ServiceBusValue = "ServiceBus";
        private const string OracleValue = "Oracle";
        private const string NoneValue = "None";

        /// <summary> Basic. </summary>
        public static CcpAuthType Basic { get; } = new CcpAuthType(BasicValue);
        /// <summary> APIKey. </summary>
        public static CcpAuthType APIKey { get; } = new CcpAuthType(APIKeyValue);
        /// <summary> OAuth2. </summary>
        public static CcpAuthType OAuth2 { get; } = new CcpAuthType(OAuth2Value);
        /// <summary> AWS. </summary>
        public static CcpAuthType AWS { get; } = new CcpAuthType(AWSValue);
        /// <summary> GCP. </summary>
        public static CcpAuthType GCP { get; } = new CcpAuthType(GCPValue);
        /// <summary> Session. </summary>
        public static CcpAuthType Session { get; } = new CcpAuthType(SessionValue);
        /// <summary> JwtToken. </summary>
        public static CcpAuthType JwtToken { get; } = new CcpAuthType(JwtTokenValue);
        /// <summary> GitHub. </summary>
        public static CcpAuthType GitHub { get; } = new CcpAuthType(GitHubValue);
        /// <summary> ServiceBus. </summary>
        public static CcpAuthType ServiceBus { get; } = new CcpAuthType(ServiceBusValue);
        /// <summary> Oracle. </summary>
        public static CcpAuthType Oracle { get; } = new CcpAuthType(OracleValue);
        /// <summary> None. </summary>
        public static CcpAuthType None { get; } = new CcpAuthType(NoneValue);
        /// <summary> Determines if two <see cref="CcpAuthType"/> values are the same. </summary>
        public static bool operator ==(CcpAuthType left, CcpAuthType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CcpAuthType"/> values are not the same. </summary>
        public static bool operator !=(CcpAuthType left, CcpAuthType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CcpAuthType"/>. </summary>
        public static implicit operator CcpAuthType(string value) => new CcpAuthType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CcpAuthType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CcpAuthType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
