// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Describes an automation rule condition that applies a boolean operator (e.g AND, OR) to conditions. </summary>
    public partial class BooleanConditionProperties : SecurityInsightsAutomationRuleCondition
    {
        /// <summary> Initializes a new instance of <see cref="BooleanConditionProperties"/>. </summary>
        public BooleanConditionProperties()
        {
            ConditionType = ConditionType.Boolean;
        }

        /// <summary> Initializes a new instance of <see cref="BooleanConditionProperties"/>. </summary>
        /// <param name="conditionType"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="conditionProperties"></param>
        internal BooleanConditionProperties(ConditionType conditionType, IDictionary<string, BinaryData> serializedAdditionalRawData, AutomationRuleBooleanCondition conditionProperties) : base(conditionType, serializedAdditionalRawData)
        {
            ConditionProperties = conditionProperties;
            ConditionType = conditionType;
        }

        /// <summary> Gets or sets the condition properties. </summary>
        [WirePath("conditionProperties")]
        public AutomationRuleBooleanCondition ConditionProperties { get; set; }
    }
}
