// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Describes the entity mappings of a single entity. </summary>
    public partial class BookmarkEntityMappings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BookmarkEntityMappings"/>. </summary>
        public BookmarkEntityMappings()
        {
            FieldMappings = new ChangeTrackingList<EntityFieldMapping>();
        }

        /// <summary> Initializes a new instance of <see cref="BookmarkEntityMappings"/>. </summary>
        /// <param name="entityType"> The entity type. </param>
        /// <param name="fieldMappings"> Array of fields mapping for that entity type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BookmarkEntityMappings(string entityType, IList<EntityFieldMapping> fieldMappings, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            EntityType = entityType;
            FieldMappings = fieldMappings;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The entity type. </summary>
        [WirePath("entityType")]
        public string EntityType { get; set; }
        /// <summary> Array of fields mapping for that entity type. </summary>
        [WirePath("fieldMappings")]
        public IList<EntityFieldMapping> FieldMappings { get; }
    }
}
