// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The kind of the billing statistic. </summary>
    internal readonly partial struct BillingStatisticKind : IEquatable<BillingStatisticKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BillingStatisticKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BillingStatisticKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SapSolutionUsageValue = "SapSolutionUsage";

        /// <summary> SapSolutionUsage. </summary>
        public static BillingStatisticKind SapSolutionUsage { get; } = new BillingStatisticKind(SapSolutionUsageValue);
        /// <summary> Determines if two <see cref="BillingStatisticKind"/> values are the same. </summary>
        public static bool operator ==(BillingStatisticKind left, BillingStatisticKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BillingStatisticKind"/> values are not the same. </summary>
        public static bool operator !=(BillingStatisticKind left, BillingStatisticKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BillingStatisticKind"/>. </summary>
        public static implicit operator BillingStatisticKind(string value) => new BillingStatisticKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BillingStatisticKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BillingStatisticKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
