// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Model for API authentication with basic flow - user name + password. </summary>
    public partial class BasicAuthModel : CcpAuthConfig
    {
        /// <summary> Initializes a new instance of <see cref="BasicAuthModel"/>. </summary>
        /// <param name="userName"> The user name. </param>
        /// <param name="password"> The password. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="userName"/> or <paramref name="password"/> is null. </exception>
        public BasicAuthModel(string userName, string password)
        {
            Argument.AssertNotNull(userName, nameof(userName));
            Argument.AssertNotNull(password, nameof(password));

            UserName = userName;
            Password = password;
            AuthType = CcpAuthType.Basic;
        }

        /// <summary> Initializes a new instance of <see cref="BasicAuthModel"/>. </summary>
        /// <param name="authType"> The auth type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="userName"> The user name. </param>
        /// <param name="password"> The password. </param>
        internal BasicAuthModel(CcpAuthType authType, IDictionary<string, BinaryData> serializedAdditionalRawData, string userName, string password) : base(authType, serializedAdditionalRawData)
        {
            UserName = userName;
            Password = password;
            AuthType = authType;
        }

        /// <summary> Initializes a new instance of <see cref="BasicAuthModel"/> for deserialization. </summary>
        internal BasicAuthModel()
        {
        }

        /// <summary> The user name. </summary>
        [WirePath("userName")]
        public string UserName { get; set; }
        /// <summary> The password. </summary>
        [WirePath("password")]
        public string Password { get; set; }
    }
}
