// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Resources created in Azure DevOps repository. </summary>
    public partial class AzureDevOpsResourceInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AzureDevOpsResourceInfo"/>. </summary>
        internal AzureDevOpsResourceInfo()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AzureDevOpsResourceInfo"/>. </summary>
        /// <param name="pipelineId"> Id of the pipeline created for the source-control. </param>
        /// <param name="serviceConnectionId"> Id of the service-connection created for the source-control. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AzureDevOpsResourceInfo(string pipelineId, string serviceConnectionId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PipelineId = pipelineId;
            ServiceConnectionId = serviceConnectionId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Id of the pipeline created for the source-control. </summary>
        [WirePath("pipelineId")]
        public string PipelineId { get; }
        /// <summary> Id of the service-connection created for the source-control. </summary>
        [WirePath("serviceConnectionId")]
        public string ServiceConnectionId { get; }
    }
}
