// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Represents Amazon Web Services S3 data connector. </summary>
    public partial class AwsS3DataConnector : SecurityInsightsDataConnectorData
    {
        /// <summary> Initializes a new instance of <see cref="AwsS3DataConnector"/>. </summary>
        public AwsS3DataConnector()
        {
            SqsUrls = new ChangeTrackingList<string>();
            Kind = DataConnectorKind.AmazonWebServicesS3;
        }

        /// <summary> Initializes a new instance of <see cref="AwsS3DataConnector"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="kind"> The data connector kind. </param>
        /// <param name="etag"> Etag of the azure resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="destinationTable"> The logs destination table name in LogAnalytics. </param>
        /// <param name="sqsUrls"> The AWS sqs urls for the connector. </param>
        /// <param name="roleArn"> The Aws Role Arn that is used to access the Aws account. </param>
        /// <param name="logs"> Logs data type. </param>
        internal AwsS3DataConnector(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, DataConnectorKind kind, ETag? etag, IDictionary<string, BinaryData> serializedAdditionalRawData, string destinationTable, IList<string> sqsUrls, string roleArn, DataConnectorDataTypeCommon logs) : base(id, name, resourceType, systemData, kind, etag, serializedAdditionalRawData)
        {
            DestinationTable = destinationTable;
            SqsUrls = sqsUrls;
            RoleArn = roleArn;
            Logs = logs;
            Kind = kind;
        }

        /// <summary> The logs destination table name in LogAnalytics. </summary>
        [WirePath("properties.destinationTable")]
        public string DestinationTable { get; set; }
        /// <summary> The AWS sqs urls for the connector. </summary>
        [WirePath("properties.sqsUrls")]
        public IList<string> SqsUrls { get; }
        /// <summary> The Aws Role Arn that is used to access the Aws account. </summary>
        [WirePath("properties.roleArn")]
        public string RoleArn { get; set; }
        /// <summary> Logs data type. </summary>
        internal DataConnectorDataTypeCommon Logs { get; set; }
        /// <summary> Describe whether this data type connection is enabled or not. </summary>
        [WirePath("properties.logs.state")]
        public SecurityInsightsDataTypeConnectionState? LogsState
        {
            get => Logs is null ? default(SecurityInsightsDataTypeConnectionState?) : Logs.State;
            set
            {
                Logs = value.HasValue ? new DataConnectorDataTypeCommon(value.Value) : null;
            }
        }
    }
}
