// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Model for API authentication with AWS. </summary>
    public partial class AwsAuthModel : CcpAuthConfig
    {
        /// <summary> Initializes a new instance of <see cref="AwsAuthModel"/>. </summary>
        /// <param name="roleArn"> AWS STS assume role ARN. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="roleArn"/> is null. </exception>
        public AwsAuthModel(string roleArn)
        {
            Argument.AssertNotNull(roleArn, nameof(roleArn));

            RoleArn = roleArn;
            AuthType = CcpAuthType.AWS;
        }

        /// <summary> Initializes a new instance of <see cref="AwsAuthModel"/>. </summary>
        /// <param name="authType"> The auth type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="roleArn"> AWS STS assume role ARN. </param>
        /// <param name="externalId"> AWS STS assume role external ID. This is used to prevent the confused deputy problem: 'https://docs.aws.amazon.com/IAM/latest/UserGuide/confused-deputy.html'. </param>
        internal AwsAuthModel(CcpAuthType authType, IDictionary<string, BinaryData> serializedAdditionalRawData, string roleArn, string externalId) : base(authType, serializedAdditionalRawData)
        {
            RoleArn = roleArn;
            ExternalId = externalId;
            AuthType = authType;
        }

        /// <summary> Initializes a new instance of <see cref="AwsAuthModel"/> for deserialization. </summary>
        internal AwsAuthModel()
        {
        }

        /// <summary> AWS STS assume role ARN. </summary>
        [WirePath("roleArn")]
        public string RoleArn { get; set; }
        /// <summary> AWS STS assume role external ID. This is used to prevent the confused deputy problem: 'https://docs.aws.amazon.com/IAM/latest/UserGuide/confused-deputy.html'. </summary>
        [WirePath("externalId")]
        public string ExternalId { get; set; }
    }
}
