// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The AutomationRuleRunPlaybookActionProperties. </summary>
    public partial class AutomationRuleRunPlaybookActionProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AutomationRuleRunPlaybookActionProperties"/>. </summary>
        /// <param name="logicAppResourceId"> The resource id of the playbook resource. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="logicAppResourceId"/> is null. </exception>
        public AutomationRuleRunPlaybookActionProperties(ResourceIdentifier logicAppResourceId)
        {
            Argument.AssertNotNull(logicAppResourceId, nameof(logicAppResourceId));

            LogicAppResourceId = logicAppResourceId;
        }

        /// <summary> Initializes a new instance of <see cref="AutomationRuleRunPlaybookActionProperties"/>. </summary>
        /// <param name="logicAppResourceId"> The resource id of the playbook resource. </param>
        /// <param name="tenantId"> The tenant id of the playbook resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AutomationRuleRunPlaybookActionProperties(ResourceIdentifier logicAppResourceId, Guid? tenantId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            LogicAppResourceId = logicAppResourceId;
            TenantId = tenantId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="AutomationRuleRunPlaybookActionProperties"/> for deserialization. </summary>
        internal AutomationRuleRunPlaybookActionProperties()
        {
        }

        /// <summary> The resource id of the playbook resource. </summary>
        [WirePath("logicAppResourceId")]
        public ResourceIdentifier LogicAppResourceId { get; set; }
        /// <summary> The tenant id of the playbook resource. </summary>
        [WirePath("tenantId")]
        public Guid? TenantId { get; set; }
    }
}
