// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Describes an automation rule action to run a playbook. </summary>
    public partial class AutomationRuleRunPlaybookAction : SecurityInsightsAutomationRuleAction
    {
        /// <summary> Initializes a new instance of <see cref="AutomationRuleRunPlaybookAction"/>. </summary>
        /// <param name="order"></param>
        public AutomationRuleRunPlaybookAction(int order) : base(order)
        {
            ActionType = ActionType.RunPlaybook;
        }

        /// <summary> Initializes a new instance of <see cref="AutomationRuleRunPlaybookAction"/>. </summary>
        /// <param name="order"></param>
        /// <param name="actionType"> The type of the automation rule action. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="actionConfiguration"></param>
        internal AutomationRuleRunPlaybookAction(int order, ActionType actionType, IDictionary<string, BinaryData> serializedAdditionalRawData, AutomationRuleRunPlaybookActionProperties actionConfiguration) : base(order, actionType, serializedAdditionalRawData)
        {
            ActionConfiguration = actionConfiguration;
            ActionType = actionType;
        }

        /// <summary> Initializes a new instance of <see cref="AutomationRuleRunPlaybookAction"/> for deserialization. </summary>
        internal AutomationRuleRunPlaybookAction()
        {
        }

        /// <summary> Gets or sets the action configuration. </summary>
        [WirePath("actionConfiguration")]
        public AutomationRuleRunPlaybookActionProperties ActionConfiguration { get; set; }
    }
}
