// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The AutomationRulePropertyChangedConditionSupportedPropertyType. </summary>
    public readonly partial struct AutomationRulePropertyChangedConditionSupportedPropertyType : IEquatable<AutomationRulePropertyChangedConditionSupportedPropertyType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AutomationRulePropertyChangedConditionSupportedPropertyType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AutomationRulePropertyChangedConditionSupportedPropertyType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string IncidentSeverityValue = "IncidentSeverity";
        private const string IncidentStatusValue = "IncidentStatus";
        private const string IncidentOwnerValue = "IncidentOwner";

        /// <summary> Evaluate the condition on the incident severity. </summary>
        public static AutomationRulePropertyChangedConditionSupportedPropertyType IncidentSeverity { get; } = new AutomationRulePropertyChangedConditionSupportedPropertyType(IncidentSeverityValue);
        /// <summary> Evaluate the condition on the incident status. </summary>
        public static AutomationRulePropertyChangedConditionSupportedPropertyType IncidentStatus { get; } = new AutomationRulePropertyChangedConditionSupportedPropertyType(IncidentStatusValue);
        /// <summary> Evaluate the condition on the incident owner. </summary>
        public static AutomationRulePropertyChangedConditionSupportedPropertyType IncidentOwner { get; } = new AutomationRulePropertyChangedConditionSupportedPropertyType(IncidentOwnerValue);
        /// <summary> Determines if two <see cref="AutomationRulePropertyChangedConditionSupportedPropertyType"/> values are the same. </summary>
        public static bool operator ==(AutomationRulePropertyChangedConditionSupportedPropertyType left, AutomationRulePropertyChangedConditionSupportedPropertyType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AutomationRulePropertyChangedConditionSupportedPropertyType"/> values are not the same. </summary>
        public static bool operator !=(AutomationRulePropertyChangedConditionSupportedPropertyType left, AutomationRulePropertyChangedConditionSupportedPropertyType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AutomationRulePropertyChangedConditionSupportedPropertyType"/>. </summary>
        public static implicit operator AutomationRulePropertyChangedConditionSupportedPropertyType(string value) => new AutomationRulePropertyChangedConditionSupportedPropertyType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AutomationRulePropertyChangedConditionSupportedPropertyType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AutomationRulePropertyChangedConditionSupportedPropertyType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
