// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The AutomationRulePropertyArrayValuesCondition. </summary>
    public partial class AutomationRulePropertyArrayValuesCondition
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AutomationRulePropertyArrayValuesCondition"/>. </summary>
        public AutomationRulePropertyArrayValuesCondition()
        {
            ItemConditions = new ChangeTrackingList<SecurityInsightsAutomationRuleCondition>();
        }

        /// <summary> Initializes a new instance of <see cref="AutomationRulePropertyArrayValuesCondition"/>. </summary>
        /// <param name="arrayType"></param>
        /// <param name="arrayConditionType"></param>
        /// <param name="itemConditions">
        /// Please note <see cref="SecurityInsightsAutomationRuleCondition"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="BooleanConditionProperties"/>, <see cref="SecurityInsightsPropertyConditionProperties"/>, <see cref="PropertyArrayConditionProperties"/>, <see cref="SecurityInsightsPropertyArrayChangedConditionProperties"/> and <see cref="SecurityInsightsPropertyChangedConditionProperties"/>.
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AutomationRulePropertyArrayValuesCondition(AutomationRulePropertyArrayConditionSupportedArrayType? arrayType, AutomationRulePropertyArrayConditionSupportedArrayConditionType? arrayConditionType, IList<SecurityInsightsAutomationRuleCondition> itemConditions, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ArrayType = arrayType;
            ArrayConditionType = arrayConditionType;
            ItemConditions = itemConditions;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets the array type. </summary>
        [WirePath("arrayType")]
        public AutomationRulePropertyArrayConditionSupportedArrayType? ArrayType { get; set; }
        /// <summary> Gets or sets the array condition type. </summary>
        [WirePath("arrayConditionType")]
        public AutomationRulePropertyArrayConditionSupportedArrayConditionType? ArrayConditionType { get; set; }
        /// <summary>
        /// Gets the item conditions
        /// Please note <see cref="SecurityInsightsAutomationRuleCondition"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="BooleanConditionProperties"/>, <see cref="SecurityInsightsPropertyConditionProperties"/>, <see cref="PropertyArrayConditionProperties"/>, <see cref="SecurityInsightsPropertyArrayChangedConditionProperties"/> and <see cref="SecurityInsightsPropertyChangedConditionProperties"/>.
        /// </summary>
        [WirePath("itemConditions")]
        public IList<SecurityInsightsAutomationRuleCondition> ItemConditions { get; }
    }
}
