// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The AutomationRulePropertyArrayConditionSupportedArrayType. </summary>
    public readonly partial struct AutomationRulePropertyArrayConditionSupportedArrayType : IEquatable<AutomationRulePropertyArrayConditionSupportedArrayType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AutomationRulePropertyArrayConditionSupportedArrayType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AutomationRulePropertyArrayConditionSupportedArrayType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CustomDetailsValue = "CustomDetails";
        private const string CustomDetailValuesValue = "CustomDetailValues";

        /// <summary> Evaluate the condition on the custom detail keys. </summary>
        public static AutomationRulePropertyArrayConditionSupportedArrayType CustomDetails { get; } = new AutomationRulePropertyArrayConditionSupportedArrayType(CustomDetailsValue);
        /// <summary> Evaluate the condition on a custom detail's values. </summary>
        public static AutomationRulePropertyArrayConditionSupportedArrayType CustomDetailValues { get; } = new AutomationRulePropertyArrayConditionSupportedArrayType(CustomDetailValuesValue);
        /// <summary> Determines if two <see cref="AutomationRulePropertyArrayConditionSupportedArrayType"/> values are the same. </summary>
        public static bool operator ==(AutomationRulePropertyArrayConditionSupportedArrayType left, AutomationRulePropertyArrayConditionSupportedArrayType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AutomationRulePropertyArrayConditionSupportedArrayType"/> values are not the same. </summary>
        public static bool operator !=(AutomationRulePropertyArrayConditionSupportedArrayType left, AutomationRulePropertyArrayConditionSupportedArrayType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AutomationRulePropertyArrayConditionSupportedArrayType"/>. </summary>
        public static implicit operator AutomationRulePropertyArrayConditionSupportedArrayType(string value) => new AutomationRulePropertyArrayConditionSupportedArrayType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AutomationRulePropertyArrayConditionSupportedArrayType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AutomationRulePropertyArrayConditionSupportedArrayType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
