// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The AutomationRulePropertyArrayConditionSupportedArrayConditionType. </summary>
    public readonly partial struct AutomationRulePropertyArrayConditionSupportedArrayConditionType : IEquatable<AutomationRulePropertyArrayConditionSupportedArrayConditionType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AutomationRulePropertyArrayConditionSupportedArrayConditionType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AutomationRulePropertyArrayConditionSupportedArrayConditionType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AnyItemValue = "AnyItem";

        /// <summary> Evaluate the condition as true if any item fulfills it. </summary>
        public static AutomationRulePropertyArrayConditionSupportedArrayConditionType AnyItem { get; } = new AutomationRulePropertyArrayConditionSupportedArrayConditionType(AnyItemValue);
        /// <summary> Determines if two <see cref="AutomationRulePropertyArrayConditionSupportedArrayConditionType"/> values are the same. </summary>
        public static bool operator ==(AutomationRulePropertyArrayConditionSupportedArrayConditionType left, AutomationRulePropertyArrayConditionSupportedArrayConditionType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AutomationRulePropertyArrayConditionSupportedArrayConditionType"/> values are not the same. </summary>
        public static bool operator !=(AutomationRulePropertyArrayConditionSupportedArrayConditionType left, AutomationRulePropertyArrayConditionSupportedArrayConditionType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AutomationRulePropertyArrayConditionSupportedArrayConditionType"/>. </summary>
        public static implicit operator AutomationRulePropertyArrayConditionSupportedArrayConditionType(string value) => new AutomationRulePropertyArrayConditionSupportedArrayConditionType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AutomationRulePropertyArrayConditionSupportedArrayConditionType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AutomationRulePropertyArrayConditionSupportedArrayConditionType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
