// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The AutomationRulePropertyArrayChangedValuesCondition. </summary>
    public partial class AutomationRulePropertyArrayChangedValuesCondition
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AutomationRulePropertyArrayChangedValuesCondition"/>. </summary>
        public AutomationRulePropertyArrayChangedValuesCondition()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AutomationRulePropertyArrayChangedValuesCondition"/>. </summary>
        /// <param name="arrayType"></param>
        /// <param name="changeType"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AutomationRulePropertyArrayChangedValuesCondition(AutomationRulePropertyArrayChangedConditionSupportedArrayType? arrayType, AutomationRulePropertyArrayChangedConditionSupportedChangeType? changeType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ArrayType = arrayType;
            ChangeType = changeType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets the array type. </summary>
        [WirePath("arrayType")]
        public AutomationRulePropertyArrayChangedConditionSupportedArrayType? ArrayType { get; set; }
        /// <summary> Gets or sets the change type. </summary>
        [WirePath("changeType")]
        public AutomationRulePropertyArrayChangedConditionSupportedChangeType? ChangeType { get; set; }
    }
}
