// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Describes an automation rule action to modify an object's properties. </summary>
    public partial class AutomationRuleModifyPropertiesAction : SecurityInsightsAutomationRuleAction
    {
        /// <summary> Initializes a new instance of <see cref="AutomationRuleModifyPropertiesAction"/>. </summary>
        /// <param name="order"></param>
        public AutomationRuleModifyPropertiesAction(int order) : base(order)
        {
            ActionType = ActionType.ModifyProperties;
        }

        /// <summary> Initializes a new instance of <see cref="AutomationRuleModifyPropertiesAction"/>. </summary>
        /// <param name="order"></param>
        /// <param name="actionType"> The type of the automation rule action. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="actionConfiguration"></param>
        internal AutomationRuleModifyPropertiesAction(int order, ActionType actionType, IDictionary<string, BinaryData> serializedAdditionalRawData, SecurityInsightsIncidentActionConfiguration actionConfiguration) : base(order, actionType, serializedAdditionalRawData)
        {
            ActionConfiguration = actionConfiguration;
            ActionType = actionType;
        }

        /// <summary> Initializes a new instance of <see cref="AutomationRuleModifyPropertiesAction"/> for deserialization. </summary>
        internal AutomationRuleModifyPropertiesAction()
        {
        }

        /// <summary> Gets or sets the action configuration. </summary>
        [WirePath("actionConfiguration")]
        public SecurityInsightsIncidentActionConfiguration ActionConfiguration { get; set; }
    }
}
