// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Describes an automation rule action to add a task to an incident. </summary>
    public partial class AutomationRuleAddIncidentTaskAction : SecurityInsightsAutomationRuleAction
    {
        /// <summary> Initializes a new instance of <see cref="AutomationRuleAddIncidentTaskAction"/>. </summary>
        /// <param name="order"></param>
        public AutomationRuleAddIncidentTaskAction(int order) : base(order)
        {
            ActionType = ActionType.AddIncidentTask;
        }

        /// <summary> Initializes a new instance of <see cref="AutomationRuleAddIncidentTaskAction"/>. </summary>
        /// <param name="order"></param>
        /// <param name="actionType"> The type of the automation rule action. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="actionConfiguration"></param>
        internal AutomationRuleAddIncidentTaskAction(int order, ActionType actionType, IDictionary<string, BinaryData> serializedAdditionalRawData, AddIncidentTaskActionProperties actionConfiguration) : base(order, actionType, serializedAdditionalRawData)
        {
            ActionConfiguration = actionConfiguration;
            ActionType = actionType;
        }

        /// <summary> Initializes a new instance of <see cref="AutomationRuleAddIncidentTaskAction"/> for deserialization. </summary>
        internal AutomationRuleAddIncidentTaskAction()
        {
        }

        /// <summary> Gets or sets the action configuration. </summary>
        [WirePath("actionConfiguration")]
        public AddIncidentTaskActionProperties ActionConfiguration { get; set; }
    }
}
