// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The directionality of this mail message. </summary>
    public readonly partial struct AntispamMailDirection : IEquatable<AntispamMailDirection>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AntispamMailDirection"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AntispamMailDirection(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string InboundValue = "Inbound";
        private const string OutboundValue = "Outbound";
        private const string IntraorgValue = "Intraorg";

        /// <summary> Unknown. </summary>
        public static AntispamMailDirection Unknown { get; } = new AntispamMailDirection(UnknownValue);
        /// <summary> Inbound. </summary>
        public static AntispamMailDirection Inbound { get; } = new AntispamMailDirection(InboundValue);
        /// <summary> Outbound. </summary>
        public static AntispamMailDirection Outbound { get; } = new AntispamMailDirection(OutboundValue);
        /// <summary> Intraorg. </summary>
        public static AntispamMailDirection Intraorg { get; } = new AntispamMailDirection(IntraorgValue);
        /// <summary> Determines if two <see cref="AntispamMailDirection"/> values are the same. </summary>
        public static bool operator ==(AntispamMailDirection left, AntispamMailDirection right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AntispamMailDirection"/> values are not the same. </summary>
        public static bool operator !=(AntispamMailDirection left, AntispamMailDirection right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AntispamMailDirection"/>. </summary>
        public static implicit operator AntispamMailDirection(string value) => new AntispamMailDirection(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AntispamMailDirection other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AntispamMailDirection other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
