// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Represents Anomaly Security ML Analytics Settings. </summary>
    public partial class AnomalySecurityMLAnalyticsSettings : SecurityMLAnalyticsSettingData
    {
        /// <summary> Initializes a new instance of <see cref="AnomalySecurityMLAnalyticsSettings"/>. </summary>
        public AnomalySecurityMLAnalyticsSettings()
        {
            RequiredDataConnectors = new ChangeTrackingList<SecurityMLAnalyticsSettingsDataSource>();
            Tactics = new ChangeTrackingList<SecurityInsightsAttackTactic>();
            Techniques = new ChangeTrackingList<string>();
            Kind = SecurityMLAnalyticsSettingsKind.Anomaly;
        }

        /// <summary> Initializes a new instance of <see cref="AnomalySecurityMLAnalyticsSettings"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="kind"> The kind of security ML Analytics Settings. </param>
        /// <param name="etag"> Etag of the azure resource. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="description"> The description of the SecurityMLAnalyticsSettings. </param>
        /// <param name="displayName"> The display name for settings created by this SecurityMLAnalyticsSettings. </param>
        /// <param name="isEnabled"> Determines whether this settings is enabled or disabled. </param>
        /// <param name="lastModifiedOn"> The last time that this SecurityMLAnalyticsSettings has been modified. </param>
        /// <param name="requiredDataConnectors"> The required data sources for this SecurityMLAnalyticsSettings. </param>
        /// <param name="tactics"> The tactics of the SecurityMLAnalyticsSettings. </param>
        /// <param name="techniques"> The techniques of the SecurityMLAnalyticsSettings. </param>
        /// <param name="anomalyVersion"> The anomaly version of the AnomalySecurityMLAnalyticsSettings. </param>
        /// <param name="customizableObservations"> The customizable observations of the AnomalySecurityMLAnalyticsSettings. </param>
        /// <param name="frequency"> The frequency that this SecurityMLAnalyticsSettings will be run. </param>
        /// <param name="settingsStatus"> The anomaly SecurityMLAnalyticsSettings status. </param>
        /// <param name="isDefaultSettings"> Determines whether this anomaly security ml analytics settings is a default settings. </param>
        /// <param name="anomalySettingsVersion"> The anomaly settings version of the Anomaly security ml analytics settings that dictates whether job version gets updated or not. </param>
        /// <param name="settingsDefinitionId"> The anomaly settings definition Id. </param>
        internal AnomalySecurityMLAnalyticsSettings(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, SecurityMLAnalyticsSettingsKind kind, ETag? etag, IDictionary<string, BinaryData> serializedAdditionalRawData, string description, string displayName, bool? isEnabled, DateTimeOffset? lastModifiedOn, IList<SecurityMLAnalyticsSettingsDataSource> requiredDataConnectors, IList<SecurityInsightsAttackTactic> tactics, IList<string> techniques, string anomalyVersion, BinaryData customizableObservations, TimeSpan? frequency, AnomalySecurityMLAnalyticsSettingsStatus? settingsStatus, bool? isDefaultSettings, int? anomalySettingsVersion, Guid? settingsDefinitionId) : base(id, name, resourceType, systemData, kind, etag, serializedAdditionalRawData)
        {
            Description = description;
            DisplayName = displayName;
            IsEnabled = isEnabled;
            LastModifiedOn = lastModifiedOn;
            RequiredDataConnectors = requiredDataConnectors;
            Tactics = tactics;
            Techniques = techniques;
            AnomalyVersion = anomalyVersion;
            CustomizableObservations = customizableObservations;
            Frequency = frequency;
            SettingsStatus = settingsStatus;
            IsDefaultSettings = isDefaultSettings;
            AnomalySettingsVersion = anomalySettingsVersion;
            SettingsDefinitionId = settingsDefinitionId;
            Kind = kind;
        }

        /// <summary> The description of the SecurityMLAnalyticsSettings. </summary>
        [WirePath("properties.description")]
        public string Description { get; set; }
        /// <summary> The display name for settings created by this SecurityMLAnalyticsSettings. </summary>
        [WirePath("properties.displayName")]
        public string DisplayName { get; set; }
        /// <summary> Determines whether this settings is enabled or disabled. </summary>
        [WirePath("properties.enabled")]
        public bool? IsEnabled { get; set; }
        /// <summary> The last time that this SecurityMLAnalyticsSettings has been modified. </summary>
        [WirePath("properties.lastModifiedUtc")]
        public DateTimeOffset? LastModifiedOn { get; }
        /// <summary> The required data sources for this SecurityMLAnalyticsSettings. </summary>
        [WirePath("properties.requiredDataConnectors")]
        public IList<SecurityMLAnalyticsSettingsDataSource> RequiredDataConnectors { get; }
        /// <summary> The tactics of the SecurityMLAnalyticsSettings. </summary>
        [WirePath("properties.tactics")]
        public IList<SecurityInsightsAttackTactic> Tactics { get; }
        /// <summary> The techniques of the SecurityMLAnalyticsSettings. </summary>
        [WirePath("properties.techniques")]
        public IList<string> Techniques { get; }
        /// <summary> The anomaly version of the AnomalySecurityMLAnalyticsSettings. </summary>
        [WirePath("properties.anomalyVersion")]
        public string AnomalyVersion { get; set; }
        /// <summary>
        /// The customizable observations of the AnomalySecurityMLAnalyticsSettings.
        /// <para>
        /// To assign an object to this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        [WirePath("properties.customizableObservations")]
        public BinaryData CustomizableObservations { get; set; }
        /// <summary> The frequency that this SecurityMLAnalyticsSettings will be run. </summary>
        [WirePath("properties.frequency")]
        public TimeSpan? Frequency { get; set; }
        /// <summary> The anomaly SecurityMLAnalyticsSettings status. </summary>
        [WirePath("properties.settingsStatus")]
        public AnomalySecurityMLAnalyticsSettingsStatus? SettingsStatus { get; set; }
        /// <summary> Determines whether this anomaly security ml analytics settings is a default settings. </summary>
        [WirePath("properties.isDefaultSettings")]
        public bool? IsDefaultSettings { get; set; }
        /// <summary> The anomaly settings version of the Anomaly security ml analytics settings that dictates whether job version gets updated or not. </summary>
        [WirePath("properties.anomalySettingsVersion")]
        public int? AnomalySettingsVersion { get; set; }
        /// <summary> The anomaly settings definition Id. </summary>
        [WirePath("properties.settingsDefinitionId")]
        public Guid? SettingsDefinitionId { get; set; }
    }
}
