// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> Represents Activity entity query. </summary>
    public partial class ActivityEntityQueryTemplate : SecurityInsightsEntityQueryTemplateData
    {
        /// <summary> Initializes a new instance of <see cref="ActivityEntityQueryTemplate"/>. </summary>
        public ActivityEntityQueryTemplate()
        {
            DataTypes = new ChangeTrackingList<DataTypeDefinitions>();
            RequiredInputFieldsSets = new ChangeTrackingList<IList<string>>();
            EntitiesFilter = new ChangeTrackingDictionary<string, IList<string>>();
            Kind = EntityQueryTemplateKind.Activity;
        }

        /// <summary> Initializes a new instance of <see cref="ActivityEntityQueryTemplate"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="kind"> the entity query template kind. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="title"> The entity query title. </param>
        /// <param name="content"> The entity query content to display in timeline. </param>
        /// <param name="description"> The entity query description. </param>
        /// <param name="queryDefinitions"> The Activity query definitions. </param>
        /// <param name="dataTypes"> List of required data types for the given entity query template. </param>
        /// <param name="inputEntityType"> The type of the query's source entity. </param>
        /// <param name="requiredInputFieldsSets"> List of the fields of the source entity that are required to run the query. </param>
        /// <param name="entitiesFilter"> The query applied only to entities matching to all filters. </param>
        internal ActivityEntityQueryTemplate(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, EntityQueryTemplateKind kind, IDictionary<string, BinaryData> serializedAdditionalRawData, string title, string content, string description, ActivityEntityQueryDefinition queryDefinitions, IList<DataTypeDefinitions> dataTypes, SecurityInsightsEntityType? inputEntityType, IList<IList<string>> requiredInputFieldsSets, IDictionary<string, IList<string>> entitiesFilter) : base(id, name, resourceType, systemData, kind, serializedAdditionalRawData)
        {
            Title = title;
            Content = content;
            Description = description;
            QueryDefinitions = queryDefinitions;
            DataTypes = dataTypes;
            InputEntityType = inputEntityType;
            RequiredInputFieldsSets = requiredInputFieldsSets;
            EntitiesFilter = entitiesFilter;
            Kind = kind;
        }

        /// <summary> The entity query title. </summary>
        [WirePath("properties.title")]
        public string Title { get; set; }
        /// <summary> The entity query content to display in timeline. </summary>
        [WirePath("properties.content")]
        public string Content { get; set; }
        /// <summary> The entity query description. </summary>
        [WirePath("properties.description")]
        public string Description { get; set; }
        /// <summary> The Activity query definitions. </summary>
        [WirePath("properties.queryDefinitions")]
        public ActivityEntityQueryDefinition QueryDefinitions { get; set; }
        /// <summary> List of required data types for the given entity query template. </summary>
        [WirePath("properties.dataTypes")]
        public IList<DataTypeDefinitions> DataTypes { get; }
        /// <summary> The type of the query's source entity. </summary>
        [WirePath("properties.inputEntityType")]
        public SecurityInsightsEntityType? InputEntityType { get; set; }
        /// <summary> List of the fields of the source entity that are required to run the query. </summary>
        [WirePath("properties.requiredInputFieldsSets")]
        public IList<IList<string>> RequiredInputFieldsSets { get; }
        /// <summary> The query applied only to entities matching to all filters. </summary>
        [WirePath("properties.entitiesFilter")]
        public IDictionary<string, IList<string>> EntitiesFilter { get; }
    }
}
