// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityInsights.Models
{
    /// <summary> The Activity query definitions. </summary>
    public partial class ActivityEntityQueryDefinition
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ActivityEntityQueryDefinition"/>. </summary>
        public ActivityEntityQueryDefinition()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ActivityEntityQueryDefinition"/>. </summary>
        /// <param name="query"> The Activity query to run on a given entity. </param>
        /// <param name="summarizeBy"> The dimensions we want to summarize the timeline results on, this is comma separated list. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ActivityEntityQueryDefinition(string query, string summarizeBy, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Query = query;
            SummarizeBy = summarizeBy;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The Activity query to run on a given entity. </summary>
        [WirePath("query")]
        public string Query { get; set; }
        /// <summary> The dimensions we want to summarize the timeline results on, this is comma separated list. </summary>
        [WirePath("summarizeBy")]
        public string SummarizeBy { get; set; }
    }
}
