// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.SecurityInsights.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableSecurityInsightsArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableSecurityInsightsArmClient"/> class for mocking. </summary>
        protected MockableSecurityInsightsArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableSecurityInsightsArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableSecurityInsightsArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableSecurityInsightsArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing a <see cref="SecurityInsightsAlertRuleResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SecurityInsightsAlertRuleResource.CreateResourceIdentifier" /> to create a <see cref="SecurityInsightsAlertRuleResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SecurityInsightsAlertRuleResource"/> object. </returns>
        public virtual SecurityInsightsAlertRuleResource GetSecurityInsightsAlertRuleResource(ResourceIdentifier id)
        {
            SecurityInsightsAlertRuleResource.ValidateResourceId(id);
            return new SecurityInsightsAlertRuleResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SecurityInsightsAlertRuleActionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SecurityInsightsAlertRuleActionResource.CreateResourceIdentifier" /> to create a <see cref="SecurityInsightsAlertRuleActionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SecurityInsightsAlertRuleActionResource"/> object. </returns>
        public virtual SecurityInsightsAlertRuleActionResource GetSecurityInsightsAlertRuleActionResource(ResourceIdentifier id)
        {
            SecurityInsightsAlertRuleActionResource.ValidateResourceId(id);
            return new SecurityInsightsAlertRuleActionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SecurityInsightsAlertRuleTemplateResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SecurityInsightsAlertRuleTemplateResource.CreateResourceIdentifier" /> to create a <see cref="SecurityInsightsAlertRuleTemplateResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SecurityInsightsAlertRuleTemplateResource"/> object. </returns>
        public virtual SecurityInsightsAlertRuleTemplateResource GetSecurityInsightsAlertRuleTemplateResource(ResourceIdentifier id)
        {
            SecurityInsightsAlertRuleTemplateResource.ValidateResourceId(id);
            return new SecurityInsightsAlertRuleTemplateResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SecurityInsightsAutomationRuleResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SecurityInsightsAutomationRuleResource.CreateResourceIdentifier" /> to create a <see cref="SecurityInsightsAutomationRuleResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SecurityInsightsAutomationRuleResource"/> object. </returns>
        public virtual SecurityInsightsAutomationRuleResource GetSecurityInsightsAutomationRuleResource(ResourceIdentifier id)
        {
            SecurityInsightsAutomationRuleResource.ValidateResourceId(id);
            return new SecurityInsightsAutomationRuleResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SecurityInsightsEntityResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SecurityInsightsEntityResource.CreateResourceIdentifier" /> to create a <see cref="SecurityInsightsEntityResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SecurityInsightsEntityResource"/> object. </returns>
        public virtual SecurityInsightsEntityResource GetSecurityInsightsEntityResource(ResourceIdentifier id)
        {
            SecurityInsightsEntityResource.ValidateResourceId(id);
            return new SecurityInsightsEntityResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SecurityInsightsIncidentResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SecurityInsightsIncidentResource.CreateResourceIdentifier" /> to create a <see cref="SecurityInsightsIncidentResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SecurityInsightsIncidentResource"/> object. </returns>
        public virtual SecurityInsightsIncidentResource GetSecurityInsightsIncidentResource(ResourceIdentifier id)
        {
            SecurityInsightsIncidentResource.ValidateResourceId(id);
            return new SecurityInsightsIncidentResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SecurityInsightsBillingStatisticResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SecurityInsightsBillingStatisticResource.CreateResourceIdentifier" /> to create a <see cref="SecurityInsightsBillingStatisticResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SecurityInsightsBillingStatisticResource"/> object. </returns>
        public virtual SecurityInsightsBillingStatisticResource GetSecurityInsightsBillingStatisticResource(ResourceIdentifier id)
        {
            SecurityInsightsBillingStatisticResource.ValidateResourceId(id);
            return new SecurityInsightsBillingStatisticResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SecurityInsightsBookmarkResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SecurityInsightsBookmarkResource.CreateResourceIdentifier" /> to create a <see cref="SecurityInsightsBookmarkResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SecurityInsightsBookmarkResource"/> object. </returns>
        public virtual SecurityInsightsBookmarkResource GetSecurityInsightsBookmarkResource(ResourceIdentifier id)
        {
            SecurityInsightsBookmarkResource.ValidateResourceId(id);
            return new SecurityInsightsBookmarkResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SecurityInsightsBookmarkRelationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SecurityInsightsBookmarkRelationResource.CreateResourceIdentifier" /> to create a <see cref="SecurityInsightsBookmarkRelationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SecurityInsightsBookmarkRelationResource"/> object. </returns>
        public virtual SecurityInsightsBookmarkRelationResource GetSecurityInsightsBookmarkRelationResource(ResourceIdentifier id)
        {
            SecurityInsightsBookmarkRelationResource.ValidateResourceId(id);
            return new SecurityInsightsBookmarkRelationResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SecurityInsightsEntityRelationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SecurityInsightsEntityRelationResource.CreateResourceIdentifier" /> to create a <see cref="SecurityInsightsEntityRelationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SecurityInsightsEntityRelationResource"/> object. </returns>
        public virtual SecurityInsightsEntityRelationResource GetSecurityInsightsEntityRelationResource(ResourceIdentifier id)
        {
            SecurityInsightsEntityRelationResource.ValidateResourceId(id);
            return new SecurityInsightsEntityRelationResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SecurityInsightsIncidentRelationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SecurityInsightsIncidentRelationResource.CreateResourceIdentifier" /> to create a <see cref="SecurityInsightsIncidentRelationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SecurityInsightsIncidentRelationResource"/> object. </returns>
        public virtual SecurityInsightsIncidentRelationResource GetSecurityInsightsIncidentRelationResource(ResourceIdentifier id)
        {
            SecurityInsightsIncidentRelationResource.ValidateResourceId(id);
            return new SecurityInsightsIncidentRelationResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SecurityInsightsPackageResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SecurityInsightsPackageResource.CreateResourceIdentifier" /> to create a <see cref="SecurityInsightsPackageResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SecurityInsightsPackageResource"/> object. </returns>
        public virtual SecurityInsightsPackageResource GetSecurityInsightsPackageResource(ResourceIdentifier id)
        {
            SecurityInsightsPackageResource.ValidateResourceId(id);
            return new SecurityInsightsPackageResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SecurityInsightsProductPackageResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SecurityInsightsProductPackageResource.CreateResourceIdentifier" /> to create a <see cref="SecurityInsightsProductPackageResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SecurityInsightsProductPackageResource"/> object. </returns>
        public virtual SecurityInsightsProductPackageResource GetSecurityInsightsProductPackageResource(ResourceIdentifier id)
        {
            SecurityInsightsProductPackageResource.ValidateResourceId(id);
            return new SecurityInsightsProductPackageResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SecurityInsightsProductTemplateResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SecurityInsightsProductTemplateResource.CreateResourceIdentifier" /> to create a <see cref="SecurityInsightsProductTemplateResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SecurityInsightsProductTemplateResource"/> object. </returns>
        public virtual SecurityInsightsProductTemplateResource GetSecurityInsightsProductTemplateResource(ResourceIdentifier id)
        {
            SecurityInsightsProductTemplateResource.ValidateResourceId(id);
            return new SecurityInsightsProductTemplateResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SecurityInsightsTemplateResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SecurityInsightsTemplateResource.CreateResourceIdentifier" /> to create a <see cref="SecurityInsightsTemplateResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SecurityInsightsTemplateResource"/> object. </returns>
        public virtual SecurityInsightsTemplateResource GetSecurityInsightsTemplateResource(ResourceIdentifier id)
        {
            SecurityInsightsTemplateResource.ValidateResourceId(id);
            return new SecurityInsightsTemplateResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SecurityInsightsEntityQueryResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SecurityInsightsEntityQueryResource.CreateResourceIdentifier" /> to create a <see cref="SecurityInsightsEntityQueryResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SecurityInsightsEntityQueryResource"/> object. </returns>
        public virtual SecurityInsightsEntityQueryResource GetSecurityInsightsEntityQueryResource(ResourceIdentifier id)
        {
            SecurityInsightsEntityQueryResource.ValidateResourceId(id);
            return new SecurityInsightsEntityQueryResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SecurityInsightsEntityQueryTemplateResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SecurityInsightsEntityQueryTemplateResource.CreateResourceIdentifier" /> to create a <see cref="SecurityInsightsEntityQueryTemplateResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SecurityInsightsEntityQueryTemplateResource"/> object. </returns>
        public virtual SecurityInsightsEntityQueryTemplateResource GetSecurityInsightsEntityQueryTemplateResource(ResourceIdentifier id)
        {
            SecurityInsightsEntityQueryTemplateResource.ValidateResourceId(id);
            return new SecurityInsightsEntityQueryTemplateResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SecurityInsightsFileImportResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SecurityInsightsFileImportResource.CreateResourceIdentifier" /> to create a <see cref="SecurityInsightsFileImportResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SecurityInsightsFileImportResource"/> object. </returns>
        public virtual SecurityInsightsFileImportResource GetSecurityInsightsFileImportResource(ResourceIdentifier id)
        {
            SecurityInsightsFileImportResource.ValidateResourceId(id);
            return new SecurityInsightsFileImportResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SecurityInsightsHuntResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SecurityInsightsHuntResource.CreateResourceIdentifier" /> to create a <see cref="SecurityInsightsHuntResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SecurityInsightsHuntResource"/> object. </returns>
        public virtual SecurityInsightsHuntResource GetSecurityInsightsHuntResource(ResourceIdentifier id)
        {
            SecurityInsightsHuntResource.ValidateResourceId(id);
            return new SecurityInsightsHuntResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SecurityInsightsHuntRelationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SecurityInsightsHuntRelationResource.CreateResourceIdentifier" /> to create a <see cref="SecurityInsightsHuntRelationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SecurityInsightsHuntRelationResource"/> object. </returns>
        public virtual SecurityInsightsHuntRelationResource GetSecurityInsightsHuntRelationResource(ResourceIdentifier id)
        {
            SecurityInsightsHuntRelationResource.ValidateResourceId(id);
            return new SecurityInsightsHuntRelationResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SecurityInsightsHuntCommentResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SecurityInsightsHuntCommentResource.CreateResourceIdentifier" /> to create a <see cref="SecurityInsightsHuntCommentResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SecurityInsightsHuntCommentResource"/> object. </returns>
        public virtual SecurityInsightsHuntCommentResource GetSecurityInsightsHuntCommentResource(ResourceIdentifier id)
        {
            SecurityInsightsHuntCommentResource.ValidateResourceId(id);
            return new SecurityInsightsHuntCommentResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SecurityInsightsIncidentCommentResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SecurityInsightsIncidentCommentResource.CreateResourceIdentifier" /> to create a <see cref="SecurityInsightsIncidentCommentResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SecurityInsightsIncidentCommentResource"/> object. </returns>
        public virtual SecurityInsightsIncidentCommentResource GetSecurityInsightsIncidentCommentResource(ResourceIdentifier id)
        {
            SecurityInsightsIncidentCommentResource.ValidateResourceId(id);
            return new SecurityInsightsIncidentCommentResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SecurityInsightsIncidentTaskResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SecurityInsightsIncidentTaskResource.CreateResourceIdentifier" /> to create a <see cref="SecurityInsightsIncidentTaskResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SecurityInsightsIncidentTaskResource"/> object. </returns>
        public virtual SecurityInsightsIncidentTaskResource GetSecurityInsightsIncidentTaskResource(ResourceIdentifier id)
        {
            SecurityInsightsIncidentTaskResource.ValidateResourceId(id);
            return new SecurityInsightsIncidentTaskResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SecurityInsightsMetadataResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SecurityInsightsMetadataResource.CreateResourceIdentifier" /> to create a <see cref="SecurityInsightsMetadataResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SecurityInsightsMetadataResource"/> object. </returns>
        public virtual SecurityInsightsMetadataResource GetSecurityInsightsMetadataResource(ResourceIdentifier id)
        {
            SecurityInsightsMetadataResource.ValidateResourceId(id);
            return new SecurityInsightsMetadataResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SecurityInsightsOfficeConsentResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SecurityInsightsOfficeConsentResource.CreateResourceIdentifier" /> to create a <see cref="SecurityInsightsOfficeConsentResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SecurityInsightsOfficeConsentResource"/> object. </returns>
        public virtual SecurityInsightsOfficeConsentResource GetSecurityInsightsOfficeConsentResource(ResourceIdentifier id)
        {
            SecurityInsightsOfficeConsentResource.ValidateResourceId(id);
            return new SecurityInsightsOfficeConsentResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SecurityInsightsSentinelOnboardingStateResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SecurityInsightsSentinelOnboardingStateResource.CreateResourceIdentifier" /> to create a <see cref="SecurityInsightsSentinelOnboardingStateResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SecurityInsightsSentinelOnboardingStateResource"/> object. </returns>
        public virtual SecurityInsightsSentinelOnboardingStateResource GetSecurityInsightsSentinelOnboardingStateResource(ResourceIdentifier id)
        {
            SecurityInsightsSentinelOnboardingStateResource.ValidateResourceId(id);
            return new SecurityInsightsSentinelOnboardingStateResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SecurityInsightsRecommendationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SecurityInsightsRecommendationResource.CreateResourceIdentifier" /> to create a <see cref="SecurityInsightsRecommendationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SecurityInsightsRecommendationResource"/> object. </returns>
        public virtual SecurityInsightsRecommendationResource GetSecurityInsightsRecommendationResource(ResourceIdentifier id)
        {
            SecurityInsightsRecommendationResource.ValidateResourceId(id);
            return new SecurityInsightsRecommendationResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SecurityMLAnalyticsSettingResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SecurityMLAnalyticsSettingResource.CreateResourceIdentifier" /> to create a <see cref="SecurityMLAnalyticsSettingResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SecurityMLAnalyticsSettingResource"/> object. </returns>
        public virtual SecurityMLAnalyticsSettingResource GetSecurityMLAnalyticsSettingResource(ResourceIdentifier id)
        {
            SecurityMLAnalyticsSettingResource.ValidateResourceId(id);
            return new SecurityMLAnalyticsSettingResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SecurityInsightsSettingResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SecurityInsightsSettingResource.CreateResourceIdentifier" /> to create a <see cref="SecurityInsightsSettingResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SecurityInsightsSettingResource"/> object. </returns>
        public virtual SecurityInsightsSettingResource GetSecurityInsightsSettingResource(ResourceIdentifier id)
        {
            SecurityInsightsSettingResource.ValidateResourceId(id);
            return new SecurityInsightsSettingResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SecurityInsightsSourceControlResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SecurityInsightsSourceControlResource.CreateResourceIdentifier" /> to create a <see cref="SecurityInsightsSourceControlResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SecurityInsightsSourceControlResource"/> object. </returns>
        public virtual SecurityInsightsSourceControlResource GetSecurityInsightsSourceControlResource(ResourceIdentifier id)
        {
            SecurityInsightsSourceControlResource.ValidateResourceId(id);
            return new SecurityInsightsSourceControlResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SecurityInsightsThreatIntelligenceIndicatorResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SecurityInsightsThreatIntelligenceIndicatorResource.CreateResourceIdentifier" /> to create a <see cref="SecurityInsightsThreatIntelligenceIndicatorResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SecurityInsightsThreatIntelligenceIndicatorResource"/> object. </returns>
        public virtual SecurityInsightsThreatIntelligenceIndicatorResource GetSecurityInsightsThreatIntelligenceIndicatorResource(ResourceIdentifier id)
        {
            SecurityInsightsThreatIntelligenceIndicatorResource.ValidateResourceId(id);
            return new SecurityInsightsThreatIntelligenceIndicatorResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="TriggeredAnalyticsRuleRunResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="TriggeredAnalyticsRuleRunResource.CreateResourceIdentifier" /> to create a <see cref="TriggeredAnalyticsRuleRunResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="TriggeredAnalyticsRuleRunResource"/> object. </returns>
        public virtual TriggeredAnalyticsRuleRunResource GetTriggeredAnalyticsRuleRunResource(ResourceIdentifier id)
        {
            TriggeredAnalyticsRuleRunResource.ValidateResourceId(id);
            return new TriggeredAnalyticsRuleRunResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SecurityInsightsWatchlistResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SecurityInsightsWatchlistResource.CreateResourceIdentifier" /> to create a <see cref="SecurityInsightsWatchlistResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SecurityInsightsWatchlistResource"/> object. </returns>
        public virtual SecurityInsightsWatchlistResource GetSecurityInsightsWatchlistResource(ResourceIdentifier id)
        {
            SecurityInsightsWatchlistResource.ValidateResourceId(id);
            return new SecurityInsightsWatchlistResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SecurityInsightsWatchlistItemResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SecurityInsightsWatchlistItemResource.CreateResourceIdentifier" /> to create a <see cref="SecurityInsightsWatchlistItemResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SecurityInsightsWatchlistItemResource"/> object. </returns>
        public virtual SecurityInsightsWatchlistItemResource GetSecurityInsightsWatchlistItemResource(ResourceIdentifier id)
        {
            SecurityInsightsWatchlistItemResource.ValidateResourceId(id);
            return new SecurityInsightsWatchlistItemResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="WorkspaceManagerAssignmentResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="WorkspaceManagerAssignmentResource.CreateResourceIdentifier" /> to create a <see cref="WorkspaceManagerAssignmentResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="WorkspaceManagerAssignmentResource"/> object. </returns>
        public virtual WorkspaceManagerAssignmentResource GetWorkspaceManagerAssignmentResource(ResourceIdentifier id)
        {
            WorkspaceManagerAssignmentResource.ValidateResourceId(id);
            return new WorkspaceManagerAssignmentResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="WorkspaceManagerAssignmentJobResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="WorkspaceManagerAssignmentJobResource.CreateResourceIdentifier" /> to create a <see cref="WorkspaceManagerAssignmentJobResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="WorkspaceManagerAssignmentJobResource"/> object. </returns>
        public virtual WorkspaceManagerAssignmentJobResource GetWorkspaceManagerAssignmentJobResource(ResourceIdentifier id)
        {
            WorkspaceManagerAssignmentJobResource.ValidateResourceId(id);
            return new WorkspaceManagerAssignmentJobResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="WorkspaceManagerConfigurationResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="WorkspaceManagerConfigurationResource.CreateResourceIdentifier" /> to create a <see cref="WorkspaceManagerConfigurationResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="WorkspaceManagerConfigurationResource"/> object. </returns>
        public virtual WorkspaceManagerConfigurationResource GetWorkspaceManagerConfigurationResource(ResourceIdentifier id)
        {
            WorkspaceManagerConfigurationResource.ValidateResourceId(id);
            return new WorkspaceManagerConfigurationResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="WorkspaceManagerGroupResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="WorkspaceManagerGroupResource.CreateResourceIdentifier" /> to create a <see cref="WorkspaceManagerGroupResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="WorkspaceManagerGroupResource"/> object. </returns>
        public virtual WorkspaceManagerGroupResource GetWorkspaceManagerGroupResource(ResourceIdentifier id)
        {
            WorkspaceManagerGroupResource.ValidateResourceId(id);
            return new WorkspaceManagerGroupResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="WorkspaceManagerMemberResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="WorkspaceManagerMemberResource.CreateResourceIdentifier" /> to create a <see cref="WorkspaceManagerMemberResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="WorkspaceManagerMemberResource"/> object. </returns>
        public virtual WorkspaceManagerMemberResource GetWorkspaceManagerMemberResource(ResourceIdentifier id)
        {
            WorkspaceManagerMemberResource.ValidateResourceId(id);
            return new WorkspaceManagerMemberResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SecurityInsightsDataConnectorDefinitionResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SecurityInsightsDataConnectorDefinitionResource.CreateResourceIdentifier" /> to create a <see cref="SecurityInsightsDataConnectorDefinitionResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SecurityInsightsDataConnectorDefinitionResource"/> object. </returns>
        public virtual SecurityInsightsDataConnectorDefinitionResource GetSecurityInsightsDataConnectorDefinitionResource(ResourceIdentifier id)
        {
            SecurityInsightsDataConnectorDefinitionResource.ValidateResourceId(id);
            return new SecurityInsightsDataConnectorDefinitionResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SecurityInsightsDataConnectorResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SecurityInsightsDataConnectorResource.CreateResourceIdentifier" /> to create a <see cref="SecurityInsightsDataConnectorResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SecurityInsightsDataConnectorResource"/> object. </returns>
        public virtual SecurityInsightsDataConnectorResource GetSecurityInsightsDataConnectorResource(ResourceIdentifier id)
        {
            SecurityInsightsDataConnectorResource.ValidateResourceId(id);
            return new SecurityInsightsDataConnectorResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing an <see cref="OperationalInsightsWorkspaceSecurityInsightsResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="OperationalInsightsWorkspaceSecurityInsightsResource.CreateResourceIdentifier" /> to create an <see cref="OperationalInsightsWorkspaceSecurityInsightsResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="OperationalInsightsWorkspaceSecurityInsightsResource"/> object. </returns>
        public virtual OperationalInsightsWorkspaceSecurityInsightsResource GetOperationalInsightsWorkspaceSecurityInsightsResource(ResourceIdentifier id)
        {
            OperationalInsightsWorkspaceSecurityInsightsResource.ValidateResourceId(id);
            return new OperationalInsightsWorkspaceSecurityInsightsResource(Client, id);
        }
    }
}
