// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityDevOps.Models
{
    /// <summary> The AzureDevOpsConnectorProperties. </summary>
    public partial class AzureDevOpsConnectorProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AzureDevOpsConnectorProperties"/>. </summary>
        public AzureDevOpsConnectorProperties()
        {
            Orgs = new ChangeTrackingList<AzureDevOpsOrgMetadata>();
        }

        /// <summary> Initializes a new instance of <see cref="AzureDevOpsConnectorProperties"/>. </summary>
        /// <param name="provisioningState"></param>
        /// <param name="authorization"></param>
        /// <param name="orgs"> Gets or sets org onboarding information. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AzureDevOpsConnectorProperties(ProvisioningState? provisioningState, AuthorizationInfo authorization, IList<AzureDevOpsOrgMetadata> orgs, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ProvisioningState = provisioningState;
            Authorization = authorization;
            Orgs = orgs;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets the provisioning state. </summary>
        public ProvisioningState? ProvisioningState { get; set; }
        /// <summary> Gets or sets the authorization. </summary>
        internal AuthorizationInfo Authorization { get; set; }
        /// <summary> Gets or sets one-time OAuth code to exchange for refresh and access tokens. </summary>
        public string AuthorizationCode
        {
            get => Authorization is null ? default : Authorization.Code;
            set
            {
                if (Authorization is null)
                    Authorization = new AuthorizationInfo();
                Authorization.Code = value;
            }
        }

        /// <summary> Gets or sets org onboarding information. </summary>
        public IList<AzureDevOpsOrgMetadata> Orgs { get; }
    }
}
