// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityDevOps.Models
{
    /// <summary> The AutoDiscovery. </summary>
    public readonly partial struct AutoDiscovery : IEquatable<AutoDiscovery>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AutoDiscovery"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AutoDiscovery(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DisabledValue = "Disabled";
        private const string EnabledValue = "Enabled";

        /// <summary> Disabled. </summary>
        public static AutoDiscovery Disabled { get; } = new AutoDiscovery(DisabledValue);
        /// <summary> Enabled. </summary>
        public static AutoDiscovery Enabled { get; } = new AutoDiscovery(EnabledValue);
        /// <summary> Determines if two <see cref="AutoDiscovery"/> values are the same. </summary>
        public static bool operator ==(AutoDiscovery left, AutoDiscovery right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AutoDiscovery"/> values are not the same. </summary>
        public static bool operator !=(AutoDiscovery left, AutoDiscovery right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AutoDiscovery"/>. </summary>
        public static implicit operator AutoDiscovery(string value) => new AutoDiscovery(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AutoDiscovery other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AutoDiscovery other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
