// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.SecurityDevOps.Models
{
    /// <summary> The ActionableRemediationRuleCategory. </summary>
    public readonly partial struct ActionableRemediationRuleCategory : IEquatable<ActionableRemediationRuleCategory>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ActionableRemediationRuleCategory"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ActionableRemediationRuleCategory(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CodeValue = "Code";
        private const string ArtifactsValue = "Artifacts";
        private const string DependenciesValue = "Dependencies";
        private const string SecretsValue = "Secrets";
        private const string InfrastructureAsCodeValue = "IaC";
        private const string ContainersValue = "Containers";

        /// <summary> Code. </summary>
        public static ActionableRemediationRuleCategory Code { get; } = new ActionableRemediationRuleCategory(CodeValue);
        /// <summary> Artifacts. </summary>
        public static ActionableRemediationRuleCategory Artifacts { get; } = new ActionableRemediationRuleCategory(ArtifactsValue);
        /// <summary> Dependencies. </summary>
        public static ActionableRemediationRuleCategory Dependencies { get; } = new ActionableRemediationRuleCategory(DependenciesValue);
        /// <summary> Secrets. </summary>
        public static ActionableRemediationRuleCategory Secrets { get; } = new ActionableRemediationRuleCategory(SecretsValue);
        /// <summary> IaC. </summary>
        public static ActionableRemediationRuleCategory InfrastructureAsCode { get; } = new ActionableRemediationRuleCategory(InfrastructureAsCodeValue);
        /// <summary> Containers. </summary>
        public static ActionableRemediationRuleCategory Containers { get; } = new ActionableRemediationRuleCategory(ContainersValue);
        /// <summary> Determines if two <see cref="ActionableRemediationRuleCategory"/> values are the same. </summary>
        public static bool operator ==(ActionableRemediationRuleCategory left, ActionableRemediationRuleCategory right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ActionableRemediationRuleCategory"/> values are not the same. </summary>
        public static bool operator !=(ActionableRemediationRuleCategory left, ActionableRemediationRuleCategory right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ActionableRemediationRuleCategory"/>. </summary>
        public static implicit operator ActionableRemediationRuleCategory(string value) => new ActionableRemediationRuleCategory(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ActionableRemediationRuleCategory other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ActionableRemediationRuleCategory other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
