// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.SecurityDevOps.Models
{
    /// <summary> The ActionableRemediation. </summary>
    public partial class ActionableRemediation
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ActionableRemediation"/>. </summary>
        public ActionableRemediation()
        {
            SeverityLevels = new ChangeTrackingList<string>();
            Categories = new ChangeTrackingList<ActionableRemediationRuleCategory>();
        }

        /// <summary> Initializes a new instance of <see cref="ActionableRemediation"/>. </summary>
        /// <param name="state"></param>
        /// <param name="severityLevels"></param>
        /// <param name="categories"></param>
        /// <param name="branchConfiguration"> Branch onboarding info. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ActionableRemediation(ActionableRemediationState? state, IList<string> severityLevels, IList<ActionableRemediationRuleCategory> categories, TargetBranchConfiguration branchConfiguration, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            State = state;
            SeverityLevels = severityLevels;
            Categories = categories;
            BranchConfiguration = branchConfiguration;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets or sets the state. </summary>
        public ActionableRemediationState? State { get; set; }
        /// <summary> Gets the severity levels. </summary>
        public IList<string> SeverityLevels { get; }
        /// <summary> Gets the categories. </summary>
        public IList<ActionableRemediationRuleCategory> Categories { get; }
        /// <summary> Branch onboarding info. </summary>
        internal TargetBranchConfiguration BranchConfiguration { get; set; }
        /// <summary>
        /// Gets or sets branches that should have annotations.
        ///
        /// For Ignite, we will be supporting a single default branch configuration in the UX.
        /// </summary>
        public IList<string> BranchNames
        {
            get
            {
                if (BranchConfiguration is null)
                    BranchConfiguration = new TargetBranchConfiguration();
                return BranchConfiguration.Names;
            }
        }
    }
}
