// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.SecurityDevOps
{
    internal class GitHubRepoOperationSource : IOperationSource<GitHubRepoResource>
    {
        private readonly ArmClient _client;

        internal GitHubRepoOperationSource(ArmClient client)
        {
            _client = client;
        }

        GitHubRepoResource IOperationSource<GitHubRepoResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = GitHubRepoData.DeserializeGitHubRepoData(document.RootElement);
            return new GitHubRepoResource(_client, data);
        }

        async ValueTask<GitHubRepoResource> IOperationSource<GitHubRepoResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = GitHubRepoData.DeserializeGitHubRepoData(document.RootElement);
            return new GitHubRepoResource(_client, data);
        }
    }
}
